# "食光荐客"食堂店面推荐平台设计文档

## 1. 功能需求梳理

### 1.1 学生端功能
| 功能模块 | 具体功能 | 优先级 |
|---------|---------|--------|
| 登录认证 | 微信授权登录 | 高 |
| | 身份校验（学生身份） | 高 |
| 店面浏览 | 首页推荐 | 高 |
| | 店面列表展示 | 高 |
| | 店面详情查看 | 高 |
| 店面搜索 | 关键词搜索 | 高 |
| | 条件筛选（评分、距离、类型等） | 高 |
| 店面收藏 | 收藏/取消收藏 | 中 |
| | 收藏列表查看 | 中 |
| 评价功能 | 多维度评分（口味、环境、服务） | 高 |
| | 图文评价（1-3张图片） | 高 |
| | 评价查看 | 高 |
| 反馈功能 | 反馈类型选择 | 高 |
| | 图文反馈（0-3张图片） | 高 |
| | 反馈状态跟踪 | 高 |
| | 反馈结果查看 | 高 |
| 导航功能 | 店面位置导航 | 中 |
| 个人中心 | 个人信息查看 | 中 |
| | 我的评价管理 | 中 |
| | 我的反馈管理 | 中 |
| | 我的收藏管理 | 中 |

### 1.2 商家端功能
| 功能模块 | 具体功能 | 优先级 |
|---------|---------|--------|
| 登录认证 | 账号密码登录 | 高 |
| | 入驻申请 | 高 |
| 店面管理 | 基础信息编辑（名称、地址、营业时间、联系方式等） | 高 |
| | 招牌菜品管理 | 高 |
| | 店面状态管理（营业/休息） | 高 |
| 评价管理 | 评价查看 | 高 |
| | 评价回复 | 高 |
| 数据统计 | 客流量统计 | 中 |
| | 评价数据分析 | 中 |
| | 营业数据报表 | 中 |
| 消息提醒 | 新评价通知 | 高 |
| | 系统通知 | 中 |
| 个人中心 | 商家信息管理 | 中 |
| | 密码修改 | 中 |

### 1.3 管理方端功能
| 功能模块 | 具体功能 | 优先级 |
|---------|---------|--------|
| 登录认证 | 账号密码登录 | 高 |
| | 权限管理 | 高 |
| 商家管理 | 商家入驻审核 | 高 |
| | 商家信息监管 | 高 |
| | 商家状态管理 | 高 |
| 反馈管理 | 反馈查看 | 高 |
| | 反馈处理 | 高 |
| | 反馈结果公示 | 高 |
| 评价监管 | 评价内容审核 | 中 |
| | 违规评价处理 | 中 |
| 数据报表 | 评价数据分析 | 高 |
| | 反馈数据分析 | 高 |
| | 商家经营数据分析 | 高 |
| | 报表导出（Excel/PDF） | 高 |
| 系统管理 | 用户权限管理 | 高 |
| | 系统日志查看 | 中 |
| | 敏感词库管理 | 中 |

## 2. 系统架构设计

### 2.1 架构概述
采用前后端分离架构，前端为web，后端为RESTful API服务，数据存储在关系型数据库中。

### 2.2 架构层次

| 层次 | 技术选型 | 说明 |
|------|---------|------|
| 前端层 | 微信小程序 | 学生端、商家端、管理方端小程序 |
| API网关层 | Nginx | 处理请求路由、负载均衡、安全认证 |
| 业务逻辑层 | Spring Boot | 处理核心业务逻辑、API接口实现 |
| 数据访问层 | MyBatis Plus | 数据库操作、ORM映射 |
| 数据存储层 | MySQL | 关系型数据存储 |
| 缓存层 | Redis | 热点数据缓存、会话管理 |
| 云服务 | 微信云开发 | 图片存储、云函数、消息推送 |

### 2.3 系统部署架构
- 小程序代码部署到微信小程序平台
- 后端服务部署到云服务器
- 数据库部署到云数据库服务
- 图片等静态资源存储到云存储

## 3. 数据库设计

### 3.1 实体关系图

```
+----------------+      +---------------+      +----------------+
|     User       |      |     Store     |      |   Evaluation   |
+----------------+      +---------------+      +----------------+
| id (PK)        |<-----| id (PK)       |<-----| id (PK)        |
| openid         |      | name          |      | user_id (FK)   |
| user_type      |      | address       |      | store_id (FK)  |
| username       |      | phone         |      | taste_score    |
| password       |      | business_hours|      | environment_score|
| avatar         |      | status        |      | service_score  |
| create_time    |      | create_time   |      | content        |
| update_time    |      | update_time   |      | images         |
+----------------+      | merchant_id (FK)|      | create_time    |
                         +---------------+      | update_time    |
                                                +----------------+
                                                          ^
                                                          |
+----------------+      +----------------+                |
|   Feedback     |      |   AdminAction  |                |
+----------------+      +----------------+                |
| id (PK)        |<-----| id (PK)        |                |
| user_id (FK)   |      | admin_id (FK)  |                |
| store_id (FK)  |      | action_type    |                |
| type           |      | target_id      |                |
| content        |      | content        |                |
| images         |      | create_time    |                |
| status         |      +----------------+                |
| handle_result  |                                        |
| create_time    |                                        |
| update_time    |                                        |
+----------------+----------------------------------------+
```

### 3.2 核心表结构设计

#### 3.2.1 User表
| 字段名 | 数据类型 | 长度 | 约束 | 描述 |
|--------|---------|------|------|------|
| id | BIGINT | 20 | PRIMARY KEY, AUTO_INCREMENT | 用户ID |
| openid | VARCHAR | 100 | UNIQUE | 微信OpenID |
| user_type | INT | 1 | NOT NULL | 用户类型（1：学生，2：商家，3：管理方） |
| username | VARCHAR | 50 | NOT NULL | 用户名 |
| password | VARCHAR | 100 | | 密码（仅商家和管理方） |
| avatar | VARCHAR | 200 | | 头像URL |
| phone | VARCHAR | 20 | | 手机号 |
| student_id | VARCHAR | 20 | | 学号（仅学生） |
| merchant_apply_status | INT | 1 | DEFAULT 0 | 商家入驻申请状态（0：未申请，1：审核中，2：通过，3：拒绝） |
| create_time | DATETIME | | NOT NULL | 创建时间 |
| update_time | DATETIME | | NOT NULL | 更新时间 |

#### 3.2.2 Store表
| 字段名 | 数据类型 | 长度 | 约束 | 描述 |
|--------|---------|------|------|------|
| id | BIGINT | 20 | PRIMARY KEY, AUTO_INCREMENT | 店面ID |
| name | VARCHAR | 100 | NOT NULL | 店面名称 |
| address | VARCHAR | 200 | NOT NULL | 店面地址 |
| phone | VARCHAR | 20 | | 联系电话 |
| business_hours | VARCHAR | 100 | | 营业时间 |
| description | VARCHAR | 500 | | 店面描述 |
| logo | VARCHAR | 200 | | 店面logo |
| status | INT | 1 | NOT NULL DEFAULT 1 | 店面状态（1：营业，2：休息，3：关闭） |
| merchant_id | BIGINT | 20 | FOREIGN KEY | 商家ID |
| average_score | DECIMAL | 3,2 | DEFAULT 0 | 平均评分 |
| evaluation_count | INT | 10 | DEFAULT 0 | 评价数量 |
| create_time | DATETIME | | NOT NULL | 创建时间 |
| update_time | DATETIME | | NOT NULL | 更新时间 |

#### 3.2.3 Dish表
| 字段名 | 数据类型 | 长度 | 约束 | 描述 |
|--------|---------|------|------|------|
| id | BIGINT | 20 | PRIMARY KEY, AUTO_INCREMENT | 菜品ID |
| store_id | BIGINT | 20 | FOREIGN KEY | 店面ID |
| name | VARCHAR | 100 | NOT NULL | 菜品名称 |
| price | DECIMAL | 8,2 | NOT NULL | 菜品价格 |
| description | VARCHAR | 200 | | 菜品描述 |
| image | VARCHAR | 200 | | 菜品图片 |
| is_signature | INT | 1 | DEFAULT 0 | 是否招牌菜（0：否，1：是） |
| create_time | DATETIME | | NOT NULL | 创建时间 |
| update_time | DATETIME | | NOT NULL | 更新时间 |

#### 3.2.4 Evaluation表
| 字段名 | 数据类型 | 长度 | 约束 | 描述 |
|--------|---------|------|------|------|
| id | BIGINT | 20 | PRIMARY KEY, AUTO_INCREMENT | 评价ID |
| user_id | BIGINT | 20 | FOREIGN KEY | 用户ID |
| store_id | BIGINT | 20 | FOREIGN KEY | 店面ID |
| taste_score | INT | 1 | NOT NULL | 口味评分（1-5） |
| environment_score | INT | 1 | NOT NULL | 环境评分（1-5） |
| service_score | INT | 1 | NOT NULL | 服务评分（1-5） |
| content | TEXT | | | 评价内容（5-500字） |
| images | VARCHAR | 1000 | | 图片URL列表（JSON格式） |
| reply_content | TEXT | | | 商家回复内容 |
| reply_time | DATETIME | | | 回复时间 |
| create_time | DATETIME | | NOT NULL | 创建时间 |
| update_time | DATETIME | | NOT NULL | 更新时间 |

#### 3.2.5 Feedback表
| 字段名 | 数据类型 | 长度 | 约束 | 描述 |
|--------|---------|------|------|------|
| id | BIGINT | 20 | PRIMARY KEY, AUTO_INCREMENT | 反馈ID |
| user_id | BIGINT | 20 | FOREIGN KEY | 用户ID |
| store_id | BIGINT | 20 | FOREIGN KEY | 店面ID |
| type | INT | 1 | NOT NULL | 反馈类型（1：菜品问题，2：服务问题，3：环境问题，4：其他） |
| content | TEXT | | NOT NULL | 反馈内容（5-500字） |
| images | VARCHAR | 1000 | | 图片URL列表（JSON格式） |
| status | INT | 1 | DEFAULT 0 | 处理状态（0：待处理，1：处理中，2：已解决，3：已关闭） |
| handle_result | TEXT | | | 处理结果 |
| handle_admin_id | BIGINT | 20 | FOREIGN KEY | 处理管理员ID |
| handle_time | DATETIME | | | 处理时间 |
| create_time | DATETIME | | NOT NULL | 创建时间 |
| update_time | DATETIME | | NOT NULL | 更新时间 |

#### 3.2.6 Favorite表
| 字段名 | 数据类型 | 长度 | 约束 | 描述 |
|--------|---------|------|------|------|
| id | BIGINT | 20 | PRIMARY KEY, AUTO_INCREMENT | 收藏ID |
| user_id | BIGINT | 20 | FOREIGN KEY | 用户ID |
| store_id | BIGINT | 20 | FOREIGN KEY | 店面ID |
| create_time | DATETIME | | NOT NULL | 创建时间 |

## 4. API接口设计

### 4.1 API设计原则
- 采用RESTful风格设计
- 使用JSON格式进行数据传输
- 统一的错误码和返回格式
- 完善的权限控制

### 4.2 接口分类

#### 4.2.1 公共接口
| 接口URL | 方法 | 功能描述 |
|---------|------|----------|
| /api/v1/auth/login | POST | 微信登录 |
| /api/v1/stores | GET | 获取店面列表 |
| /api/v1/stores/{id} | GET | 获取店面详情 |
| /api/v1/stores/{id}/dishes | GET | 获取店面菜品 |
| /api/v1/stores/{id}/evaluations | GET | 获取店面评价 |

#### 4.2.2 学生端接口
| 接口URL | 方法 | 功能描述 |
|---------|------|----------|
| /api/v1/student/evaluations | POST | 提交评价 |
| /api/v1/student/feedbacks | POST | 提交反馈 |
| /api/v1/student/feedbacks | GET | 获取我的反馈 |
| /api/v1/student/feedbacks/{id} | GET | 获取反馈详情 |
| /api/v1/student/favorites | POST | 收藏店面 |
| /api/v1/student/favorites | GET | 获取我的收藏 |
| /api/v1/student/favorites/{storeId} | DELETE | 取消收藏 |
| /api/v1/student/profile | GET | 获取个人信息 |

#### 4.2.3 商家端接口
| 接口URL | 方法 | 功能描述 |
|---------|------|----------|
| /api/v1/merchant/login | POST | 商家登录 |
| /api/v1/merchant/apply | POST | 入驻申请 |
| /api/v1/merchant/stores | POST | 创建店面 |
| /api/v1/merchant/stores/{id} | PUT | 更新店面信息 |
| /api/v1/merchant/stores/{id} | GET | 获取店面详情 |
| /api/v1/merchant/stores/{id}/dishes | POST | 添加菜品 |
| /api/v1/merchant/stores/{id}/dishes/{dishId} | PUT | 更新菜品 |
| /api/v1/merchant/stores/{id}/dishes/{dishId} | DELETE | 删除菜品 |
| /api/v1/merchant/evaluations | GET | 获取评价列表 |
| /api/v1/merchant/evaluations/{id}/reply | POST | 回复评价 |
| /api/v1/merchant/statistics | GET | 获取数据统计 |
| /api/v1/merchant/profile | GET | 获取商家信息 |
| /api/v1/merchant/profile | PUT | 更新商家信息 |

#### 4.2.4 管理方接口
| 接口URL | 方法 | 功能描述 |
|---------|------|----------|
| /api/v1/admin/login | POST | 管理员登录 |
| /api/v1/admin/merchants/apply | GET | 获取商家入驻申请 |
| /api/v1/admin/merchants/apply/{id} | PUT | 审核商家入驻 |
| /api/v1/admin/feedbacks | GET | 获取反馈列表 |
| /api/v1/admin/feedbacks/{id} | PUT | 处理反馈 |
| /api/v1/admin/reports | GET | 生成数据报表 |
| /api/v1/admin/reports/export | GET | 导出报表 |
| /api/v1/admin/users | GET | 获取用户列表 |
| /api/v1/admin/users/{id} | PUT | 修改用户权限 |

### 4.3 统一返回格式

```json
{
  "code": 200,
  "message": "success",
  "data": {
    // 业务数据
  },
  "timestamp": 1620000000000
}
```

## 5. 前端设计

### 5.1 页面结构设计

#### 5.1.1 学生端页面结构
| 页面层级 | 页面名称 | 主要功能 |
|---------|---------|----------|
| 一级页面 | 首页 | 店面推荐、搜索入口 |
| 一级页面 | 搜索页 | 关键词搜索、条件筛选 |
| 一级页面 | 我的 | 个人信息、我的评价、我的反馈、我的收藏 |
| 二级页面 | 店面详情页 | 店面信息、评价列表、菜品列表、导航入口 |
| 二级页面 | 评价编辑页 | 提交评价（评分、文字、图片） |
| 二级页面 | 反馈编辑页 | 提交反馈（类型、文字、图片） |
| 二级页面 | 反馈详情页 | 反馈内容、处理状态、处理结果 |
| 二级页面 | 收藏列表页 | 收藏的店面列表 |

#### 5.1.2 商家端页面结构
| 页面层级 | 页面名称 | 主要功能 |
|---------|---------|----------|
| 一级页面 | 首页 | 数据概览、待处理事项 |
| 一级页面 | 店面管理 | 店面信息编辑、菜品管理 |
| 一级页面 | 评价管理 | 评价列表、评价回复 |
| 一级页面 | 我的 | 商家信息、设置 |
| 二级页面 | 菜品编辑页 | 菜品信息添加/修改 |
| 二级页面 | 数据统计页 | 详细数据报表 |

#### 5.1.3 管理方页面结构
| 页面层级 | 页面名称 | 主要功能 |
|---------|---------|----------|
| 一级页面 | 首页 | 系统概览、待处理事项 |
| 一级页面 | 商家管理 | 商家列表、入驻审核 |
| 一级页面 | 反馈管理 | 反馈列表、反馈处理 |
| 一级页面 | 报表管理 | 数据报表生成、导出 |
| 一级页面 | 系统设置 | 用户管理、权限设置 |
| 二级页面 | 商家审核页 | 商家入驻详情审核 |
| 二级页面 | 反馈处理页 | 反馈详情处理 |

### 5.2 交互设计原则

1. **操作路径简洁**：核心功能操作路径≤3步
2. **反馈及时**：操作反馈≤500ms
3. **视觉一致性**：统一的颜色、字体、间距规范
4. **响应式设计**：适配不同屏幕尺寸
5. **首次使用引导**：新用户引导流程
6. **输入验证**：实时表单验证
7. **错误处理**：友好的错误提示
8. **手势支持**：支持常用手势操作

### 5.3 关键页面流程

#### 5.3.1 学生端评价流程
1. 进入店面详情页
2. 点击"写评价"按钮
3. 选择评分（口味、环境、服务）
4. 输入评价内容（5-500字）
5. 上传图片（1-3张）
6. 点击"提交"按钮
7. 显示提交成功反馈

#### 5.3.2 商家端回复评价流程
1. 进入评价管理页
2. 查看待回复评价
3. 点击"回复"按钮
4. 输入回复内容
5. 点击"提交"按钮
6. 显示回复成功反馈

#### 5.3.3 管理方处理反馈流程
1. 进入反馈管理页
2. 查看待处理反馈
3. 点击"处理"按钮
4. 查看反馈详情
5. 输入处理结果
6. 点击"提交"按钮
7. 显示处理成功反馈

## 6. 安全性设计

### 6.1 数据安全
- 敏感数据加密存储（如密码使用BCrypt加密）
- 数据传输采用HTTPS协议
- 定期数据备份

### 6.2 身份认证与授权
- 微信登录采用OAuth2.0协议
- 商家和管理方采用JWT token认证
- 基于角色的权限控制（RBAC）
- 登录失败次数限制

### 6.3 内容安全
- 评价和反馈内容敏感词过滤
- 图片上传前审核
- 人工二次审核机制

### 6.4 系统安全
- API接口限流
- 防止SQL注入、XSS攻击
- 系统日志记录

## 7. 性能设计

### 7.1 前端性能优化
- 图片懒加载
- 页面资源缓存
- 减少HTTP请求次数
- 使用小程序分包加载

### 7.2 后端性能优化
- 数据库索引优化
- 热点数据缓存（Redis）
- API接口响应时间≤2秒
- 异步处理耗时操作

### 7.3 数据库性能优化
- 合理设计表结构
- 优化查询语句
- 定期数据库维护

## 8. 测试计划

### 8.1 测试类型
- 单元测试：对核心功能模块进行测试
- 集成测试：测试模块间的交互
- 系统测试：测试整个系统的功能和性能
- 回归测试：修复bug后进行测试
- 验收测试：用户验收测试

### 8.2 测试重点
- 核心功能的正确性
- 边界条件处理
- 性能测试（响应时间、并发处理）
- 安全性测试
- 兼容性测试（不同微信版本、不同设备）

## 9. 部署与运维

### 9.1 部署方案
- 小程序代码部署到微信小程序平台
- 后端服务部署到云服务器
- 数据库部署到云数据库服务
- 静态资源存储到云存储

### 9.2 运维方案
- 系统监控（CPU、内存、磁盘、网络）
- 日志监控与分析
- 定期备份数据
- 应急预案

## 10. 项目进度计划

| 阶段 | 时间 | 主要任务 |
|------|------|----------|
| 需求分析与设计 | 2周 | 需求确认、系统设计、数据库设计 |
| 前端开发 | 3周 | 小程序页面开发、交互实现 |
| 后端开发 | 3周 | API接口开发、业务逻辑实现 |
| 测试 | 2周 | 单元测试、集成测试、系统测试 |
| 上线准备 | 1周 | 性能优化、安全性检查、文档准备 |
| 上线部署 | 1周 | 小程序审核、后端部署、数据初始化 |
| 运营维护 | 持续 | 系统监控、bug修复、功能迭代 |

## 11. 技术栈

### 11.1 前端技术栈
- 微信小程序原生开发
- WXML、WXSS、JavaScript
- 微信云开发

### 11.2 后端技术栈
- Java 1.8+
- Spring Boot 2.5+
- Spring Security
- MyBatis Plus
- MySQL 8.0+
- Redis 6.0+
- JWT

### 11.3 开发工具
- 微信开发者工具
- IntelliJ IDEA
- Navicat
- Postman

## 12. 风险分析

| 风险类型 | 风险描述 | 应对措施 |
|---------|---------|----------|
| 需求变更 | 需求可能在开发过程中发生变化 | 建立变更管理流程，及时沟通和评估影响 |
| 技术风险 | 微信小程序API更新导致兼容性问题 | 关注微信小程序官方更新，及时调整代码 |
| 性能风险 | 系统并发量过大导致性能下降 | 进行性能测试，优化系统架构和代码 |
| 安全风险 | 系统可能面临安全攻击 | 加强安全设计，定期进行安全审计 |
| 进度风险 | 开发进度可能延迟 | 合理安排任务，定期检查进度，及时调整计划 |