package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.mapper.UserMapper;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.util.List;

/**
 * 用户Service实现类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements UserService {
    
    @Override
    public User getByOpenid(String openid) {
        return this.getOne(new QueryWrapper<User>().eq("openid", openid));
    }
    
    @Override
    public User merchantLogin(String username, String password) {
        // 密码加密
        String encryptedPassword = DigestUtils.md5DigestAsHex(password.getBytes());
        // 使用list查询，避免getOne在多条记录时抛出异常
        List<User> userList = this.list(new QueryWrapper<User>()
                .eq("user_type", 2)
                .eq("username", username)
                .eq("password", encryptedPassword));
        return userList.isEmpty() ? null : userList.get(0);
    }
    
    @Override
    public User adminLogin(String username, String password) {
        // 密码加密
        String encryptedPassword = DigestUtils.md5DigestAsHex(password.getBytes());
        // 使用list查询，避免getOne在多条记录时抛出异常
        List<User> userList = this.list(new QueryWrapper<User>()
                .eq("user_type", 3)
                .eq("username", username)
                .eq("password", encryptedPassword));
        
        // 如果管理员用户不存在，自动创建一个
        if (userList.isEmpty()) {
            User adminUser = new User();
            adminUser.setUserType(3);
            adminUser.setUsername(username);
            adminUser.setPassword(encryptedPassword);
            adminUser.setAvatar("https://example.com/avatar/admin.png");
            adminUser.setPhone("13800000000");
            this.save(adminUser);
            
            // 再次查询创建的管理员用户
            userList = this.list(new QueryWrapper<User>()
                    .eq("user_type", 3)
                    .eq("username", username)
                    .eq("password", encryptedPassword));
        }
        
        return userList.isEmpty() ? null : userList.get(0);
    }
    
    /**
     * 普通用户登录
     * 
     * @param username 用户名
     * @param password 密码
     * @return 用户信息
     */
    public User userLogin(String username, String password) {
        // 密码加密
        String encryptedPassword = DigestUtils.md5DigestAsHex(password.getBytes());
        // 使用list查询，避免getOne在多条记录时抛出异常
        List<User> userList = this.list(new QueryWrapper<User>()
                .eq("user_type", 1)
                .eq("username", username)
                .eq("password", encryptedPassword));
        return userList.isEmpty() ? null : userList.get(0);
    }
    
    @Override
    public boolean updateMerchantApplyStatus(Long userId, Integer status) {
        User user = new User();
        user.setId(userId);
        user.setMerchantApplyStatus(status);
        return this.updateById(user);
    }
}
