package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.Store;
import com.shiguangjianke.smartfoodsystem.mapper.StoreMapper;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 店面Service实现类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Service
public class StoreServiceImpl extends ServiceImpl<StoreMapper, Store> implements StoreService {
    
    @Override
    public List<Store> getByMerchantId(Long merchantId) {
        return this.list(new QueryWrapper<Store>().eq("merchant_id", merchantId));
    }
    
    @Override
    public boolean updateAverageScore(Long storeId, Double averageScore) {
        Store store = new Store();
        store.setId(storeId);
        store.setAverageScore(new java.math.BigDecimal(averageScore));
        return this.updateById(store);
    }
    
    @Override
    public boolean updateEvaluationCount(Long storeId, Integer count) {
        Store store = new Store();
        store.setId(storeId);
        store.setEvaluationCount(count);
        return this.updateById(store);
    }
    
    @Override
    public List<Store> getByStatus(Integer status) {
        return this.list(new QueryWrapper<Store>().eq("status", status));
    }
}
