package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.Feedback;
import com.shiguangjianke.smartfoodsystem.mapper.FeedbackMapper;
import com.shiguangjianke.smartfoodsystem.service.FeedbackService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 反馈Service实现类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Service
public class FeedbackServiceImpl extends ServiceImpl<FeedbackMapper, Feedback> implements FeedbackService {
    
    @Override
    public List<Feedback> getByUserId(Long userId) {
        return this.list(new QueryWrapper<Feedback>().eq("user_id", userId));
    }
    
    @Override
    public IPage<Feedback> getByUserId(Long userId, int page, int pageSize) {
        IPage<Feedback> feedbackPage = new Page<>(page, pageSize);
        return this.page(feedbackPage, new QueryWrapper<Feedback>().eq("user_id", userId).orderByDesc("create_time"));
    }
    
    @Override
    public List<Feedback> getByStatus(Integer status) {
        return this.list(new QueryWrapper<Feedback>().eq("status", status));
    }
    
    @Override
    public boolean updateStatus(Long feedbackId, Integer status) {
        Feedback feedback = new Feedback();
        feedback.setId(feedbackId);
        feedback.setStatus(status);
        return this.updateById(feedback);
    }
}
