package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.Favorite;
import com.shiguangjianke.smartfoodsystem.entity.Store;
import com.shiguangjianke.smartfoodsystem.mapper.FavoriteMapper;
import com.shiguangjianke.smartfoodsystem.service.FavoriteService;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 收藏Service实现类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Service
public class FavoriteServiceImpl extends ServiceImpl<FavoriteMapper, Favorite> implements FavoriteService {
    
    @Autowired
    private StoreService storeService;
    
    @Override
    public List<Favorite> getByUserId(Long userId) {
        return this.list(new QueryWrapper<Favorite>().eq("user_id", userId));
    }
    
    @Override
    public Favorite getByUserIdAndStoreId(Long userId, Long storeId) {
        return this.getOne(new QueryWrapper<Favorite>()
                .eq("user_id", userId)
                .eq("store_id", storeId));
    }
    
    @Override
    public boolean isFavorite(Long userId, Long storeId) {
        return this.getByUserIdAndStoreId(userId, storeId) != null;
    }
    
    @Override
    public List<Store> getFavoriteStores(Long userId) {
        // 获取用户的所有收藏记录
        List<Favorite> favorites = this.getByUserId(userId);
        List<Store> storeList = new ArrayList<>();
        
        // 遍历收藏记录，获取每个店面的详情
        for (Favorite favorite : favorites) {
            Store store = storeService.getById(favorite.getStoreId());
            if (store != null) {
                storeList.add(store);
            }
        }
        
        return storeList;
    }
}
