package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.Dish;
import com.shiguangjianke.smartfoodsystem.mapper.DishMapper;
import com.shiguangjianke.smartfoodsystem.service.DishService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 菜品Service实现类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Service
public class DishServiceImpl extends ServiceImpl<DishMapper, Dish> implements DishService {
    
    @Override
    public List<Dish> getByStoreId(Long storeId) {
        return this.list(new QueryWrapper<Dish>().eq("store_id", storeId));
    }
    

}
