package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.AdminAction;
import com.shiguangjianke.smartfoodsystem.mapper.AdminActionMapper;
import com.shiguangjianke.smartfoodsystem.service.AdminActionService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 管理员操作Service实现类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Service
public class AdminActionServiceImpl extends ServiceImpl<AdminActionMapper, AdminAction> implements AdminActionService {
    
    @Override
    public List<AdminAction> getByAdminId(Long adminId) {
        return this.list(new QueryWrapper<AdminAction>().eq("admin_id", adminId));
    }
    
    @Override
    public List<AdminAction> getByActionType(Integer actionType) {
        return this.list(new QueryWrapper<AdminAction>().eq("action_type", actionType));
    }
    
    @Override
    public boolean recordAdminAction(AdminAction adminAction) {
        return this.save(adminAction);
    }
}
