package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.User;

/**
 * 用户Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface UserService extends IService<User> {
    
    /**
     * 根据openid查询用户
     *
     * @param openid 微信openid
     * @return 用户信息
     */
    User getByOpenid(String openid);
    
    /**
     * 商家登录
     *
     * @param username 用户名
     * @param password 密码
     * @return 用户信息
     */
    User merchantLogin(String username, String password);
    
    /**
     * 管理员登录
     *
     * @param username 用户名
     * @param password 密码
     * @return 用户信息
     */
    User adminLogin(String username, String password);
    
    /**
     * 更新商家入驻申请状态
     *
     * @param userId 用户ID
     * @param status 申请状态
     * @return 更新结果
     */
    boolean updateMerchantApplyStatus(Long userId, Integer status);
}
