package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.Store;

import java.util.List;

/**
 * 店面Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface StoreService extends IService<Store> {
    
    /**
     * 根据商家ID查询店面列表
     *
     * @param merchantId 商家ID
     * @return 店面列表
     */
    List<Store> getByMerchantId(Long merchantId);
    
    /**
     * 更新店面平均评分
     *
     * @param storeId 店面ID
     * @param averageScore 平均评分
     * @return 更新结果
     */
    boolean updateAverageScore(Long storeId, Double averageScore);
    
    /**
     * 更新店面评价数量
     *
     * @param storeId 店面ID
     * @param count 评价数量
     * @return 更新结果
     */
    boolean updateEvaluationCount(Long storeId, Integer count);
    
    /**
     * 根据状态查询店面列表
     *
     * @param status 店面状态
     * @return 店面列表
     */
    List<Store> getByStatus(Integer status);
}
