package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.Order;

import java.util.List;

/**
 * 订单Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface OrderService extends IService<Order> {
    
    /**
     * 根据商家ID获取订单列表
     *
     * @param merchantId 商家ID
     * @return 订单列表
     */
    List<Order> getOrdersByMerchantId(Long merchantId);
    
    /**
     * 根据商家ID获取订单列表，支持分页
     *
     * @param merchantId 商家ID
     * @param page 页码
     * @param pageSize 每页数量
     * @return 分页订单列表
     */
    IPage<Order> getOrdersByMerchantId(Long merchantId, Integer page, Integer pageSize);
    
    /**
     * 更新订单状态
     *
     * @param orderId 订单ID
     * @param status 订单状态
     * @return 是否更新成功
     */
    boolean updateOrderStatus(Long orderId, String status);
    
    /**
     * 根据用户ID获取订单列表
     *
     * @param userId 用户ID
     * @param page 页码
     * @param pageSize 每页数量
     * @return 分页订单列表
     */
    IPage<Order> getOrdersByUserId(Long userId, Integer page, Integer pageSize);
}
