package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.Feedback;

import java.util.List;

/**
 * 反馈Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface FeedbackService extends IService<Feedback> {
    
    /**
     * 根据用户ID查询反馈列表
     *
     * @param userId 用户ID
     * @return 反馈列表
     */
    List<Feedback> getByUserId(Long userId);
    
    /**
     * 根据用户ID分页查询反馈列表
     *
     * @param userId 用户ID
     * @param page 页码
     * @param pageSize 每页大小
     * @return 分页反馈列表
     */
    IPage<Feedback> getByUserId(Long userId, int page, int pageSize);
    
    /**
     * 根据状态查询反馈列表
     *
     * @param status 反馈状态
     * @return 反馈列表
     */
    List<Feedback> getByStatus(Integer status);
    
    /**
     * 更新反馈状态
     *
     * @param feedbackId 反馈ID
     * @param status 反馈状态
     * @return 更新结果
     */
    boolean updateStatus(Long feedbackId, Integer status);
}
