package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.Favorite;
import com.shiguangjianke.smartfoodsystem.entity.Store;

import java.util.List;

/**
 * 收藏Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface FavoriteService extends IService<Favorite> {
    
    /**
     * 根据用户ID查询收藏列表
     *
     * @param userId 用户ID
     * @return 收藏列表
     */
    List<Favorite> getByUserId(Long userId);
    
    /**
     * 根据用户ID获取收藏的店面列表
     *
     * @param userId 用户ID
     * @return 收藏的店面列表
     */
    List<Store> getFavoriteStores(Long userId);
    
    /**
     * 根据用户ID和店面ID查询收藏
     *
     * @param userId 用户ID
     * @param storeId 店面ID
     * @return 收藏信息
     */
    Favorite getByUserIdAndStoreId(Long userId, Long storeId);
    
    /**
     * 判断用户是否收藏了该店面
     *
     * @param userId 用户ID
     * @param storeId 店面ID
     * @return 是否收藏
     */
    boolean isFavorite(Long userId, Long storeId);
}
