package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.Evaluation;

import java.util.Date;
import java.util.List;

/**
 * 评价Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface EvaluationService extends IService<Evaluation> {
    
    /**
     * 根据店面ID查询评价列表
     *
     * @param storeId 店面ID
     * @return 评价列表
     */
    List<Evaluation> getByStoreId(Long storeId);
    
    /**
     * 根据用户ID查询评价列表
     *
     * @param userId 用户ID
     * @return 评价列表
     */
    List<Evaluation> getByUserId(Long userId);
    
    /**
     * 根据用户ID分页查询评价列表
     *
     * @param userId 用户ID
     * @param page 页码
     * @param pageSize 每页大小
     * @return 分页评价列表
     */
    IPage<Evaluation> getByUserId(Long userId, int page, int pageSize);
    
    /**
     * 计算店面平均评分
     *
     * @param storeId 店面ID
     * @return 平均评分
     */
    Double calculateAverageScore(Long storeId);
    
    /**
     * 获取店面评价数量
     *
     * @param storeId 店面ID
     * @return 评价数量
     */
    Integer getEvaluationCount(Long storeId);
    
    /**
     * 根据店面ID分页查询评价列表
     *
     * @param storeId 店面ID
     * @param page 页码
     * @param pageSize 每页大小
     * @return 分页评价列表
     */
    IPage<Evaluation> getByStoreId(Long storeId, int page, int pageSize);
    
    /**
     * 更新评价回复
     *
     * @param evaluation 评价信息（包含回复内容）
     * @return 更新结果
     */
    boolean updateReply(Evaluation evaluation);
    
    /**
     * 分页查询所有评价
     *
     * @param page 页码
     * @param pageSize 每页大小
     * @return 分页评价列表
     */
    IPage<Evaluation> getAllEvaluations(int page, int pageSize);
    
    /**
     * 根据条件分页查询评价
     *
     * @param status 评价状态
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param page 页码
     * @param pageSize 每页大小
     * @return 分页评价列表
     */
    IPage<Evaluation> getEvaluationsByCondition(Integer status, Date startTime, Date endTime, int page, int pageSize);
    
    /**
     * 更新评价状态
     *
     * @param id 评价ID
     * @param status 评价状态
     * @return 更新结果
     */
    boolean updateEvaluationStatus(Long id, Integer status);
}
