package com.shiguangjianke.smartfoodsystem.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.AdminAction;

import java.util.List;

/**
 * 管理员操作Service接口
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public interface AdminActionService extends IService<AdminAction> {
    
    /**
     * 根据管理员ID查询操作记录
     *
     * @param adminId 管理员ID
     * @return 操作记录列表
     */
    List<AdminAction> getByAdminId(Long adminId);
    
    /**
     * 根据操作类型查询操作记录
     *
     * @param actionType 操作类型
     * @return 操作记录列表
     */
    List<AdminAction> getByActionType(Integer actionType);
    
    /**
     * 记录管理员操作
     *
     * @param adminAction 管理员操作信息
     * @return 记录结果
     */
    boolean recordAdminAction(AdminAction adminAction);
}
