package com.shiguangjianke.smartfoodsystem.init;

import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

/**
 * 应用启动时初始化数据
 */
@Component
public class DataInitializer implements ApplicationRunner {

    @Autowired
    private UserService userService;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 初始化管理员用户
        initAdminUser();
    }

    /**
     * 初始化管理员用户
     */
    private void initAdminUser() {
        // 管理员用户名
        String adminUsername = "admin";
        
        // 检查管理员用户是否已存在
        User adminUser = userService.adminLogin(adminUsername, "");
        if (adminUser == null) {
            // 创建管理员用户
            User user = new User();
            user.setUserType(3); // 管理员用户类型
            user.setUsername(adminUsername);
            user.setPassword(DigestUtils.md5DigestAsHex("admin123".getBytes())); // 密码：admin123
            
            userService.save(user);
            System.out.println("=== 管理员用户初始化成功 ===");
            System.out.println("用户名: " + adminUsername);
            System.out.println("密码: admin123");
        } else {
            System.out.println("=== 管理员用户已存在 ===");
        }
    }
}