package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 店面实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("store")
public class Store implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 店面ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 店面名称
     */
    private String name;

    /**
     * 店面地址
     */
    private String address;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 营业时间
     */
    private String businessHours;

    /**
     * 店面描述
     */
    private String description;

    /**
     * 店面logo
     */
    private String logo;

    /**
     * 店面状态（1：营业，2：休息，3：关闭）
     */
    private Integer status;

    /**
     * 商家ID
     */
    private Long merchantId;

    /**
     * 平均评分
     */
    private BigDecimal averageScore;

    /**
     * 评价数量
     */
    private Integer evaluationCount;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;
}