package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.*;
import java.util.Date;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("orders")
public class Order implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 订单ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 菜品ID
     */
    private Long dishId;
    
    /**
     * 菜品名称（非数据库字段）
     */
    @TableField(exist = false)
    private String dishName;
    
    /**
     * 用户名（非数据库字段）
     */
    @TableField(exist = false)
    private String username;
    
    /**
     * 手机号（非数据库字段）
     */
    @TableField(exist = false)
    private String phone;

    /**
     * 购买数量
     */
    private Integer quantity;

    /**
     * 备注
     */
    private String remark;

    /**
     * 订单状态（pending: 待处理, completed: 已出餐, cancelled: 已取消）
     */
    private String status;

    /**
     * 总价格
     */
    private BigDecimal totalPrice;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}