package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 反馈实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("feedback")
public class Feedback implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 反馈ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 店面ID
     */
    private Long storeId;

    /**
     * 反馈类型（1：菜品问题，2：服务问题，3：环境问题，4：其他）
     */
    private Integer type;

    /**
     * 反馈内容（5-500字）
     */
    private String content;

    /**
     * 图片URL列表（JSON格式）
     */
    private String images;

    /**
     * 处理状态（0：待处理，1：处理中，2：已解决，3：已关闭）
     */
    private Integer status;

    /**
     * 处理结果
     */
    private String handleResult;

    /**
     * 处理管理员ID
     */
    private Long handleAdminId;

    /**
     * 处理时间
     */
    private Date handleTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;
}