package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 收藏实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("favorite")
public class Favorite implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 收藏ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 店面ID
     */
    private Long storeId;

    /**
     * 创建时间
     */
    private Date createTime;
    
    // 手动添加缺失的getter方法
    public Long getId() {
        return this.id;
    }
    
    public Long getStoreId() {
        return this.storeId;
    }
    
    public Long getUserId() {
        return this.userId;
    }
}