package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 评价实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("evaluation")
public class Evaluation implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 评价ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 店面ID
     */
    private Long storeId;

    /**
     * 口味评分（1-5）
     */
    private Integer tasteScore;

    /**
     * 环境评分（1-5）
     */
    private Integer environmentScore;

    /**
     * 服务评分（1-5）
     */
    private Integer serviceScore;
    
    /**
     * 卫生评分（1-5）
     */
    private Integer hygieneScore;
    
    /**
     * 评价内容
     */
    private String content;

    /**
     * 图片URL列表（JSON格式）
     */
    private String images;

    /**
     * 商家回复内容
     */
    private String replyContent;

    /**
     * 回复时间
     */
    private Date replyTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;
    
    /**
     * 评价状态：0-待审核，1-已通过，2-已驳回
     */
    private Integer status;
}