package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 菜品实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("dish")
public class Dish implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 菜品ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 店面ID
     */
    private Long storeId;

    /**
     * 菜品名称
     */
    @TableField("name")
    private String name;

    /**
     * 菜品价格
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 菜品描述
     */
    @TableField("description")
    private String description;

    /**
     * 菜品图片
     */
    @TableField("image")
    private String image;

    /**
     * 是否招牌菜
     */
    @TableField("is_signature")
    private Boolean isSignature;
    
    /**
     * 状态：on_sale：上架，off_sale：下架
     */
    @TableField(exist = false)
    private String status;
    
    /**
     * 创建时间
     */
    @TableField("create_time")
    private Date createTime;
    
    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;
}