package com.shiguangjianke.smartfoodsystem.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 管理员操作实体类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@Data
@TableName("admin_action")
public class AdminAction implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 操作ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 管理员ID
     */
    private Long adminId;

    /**
     * 操作类型（1：审核商家，2：处理反馈，3：管理权限）
     */
    private Integer actionType;

    /**
     * 目标ID（商家ID/反馈ID/用户ID）
     */
    private Long targetId;

    /**
     * 操作内容
     */
    private String content;

    /**
     * 创建时间
     */
    private Date createTime;
}