package com.shiguangjianke.smartfoodsystem.controller;

import com.shiguangjianke.smartfoodsystem.controller.Result;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

/**
 * 文件上传Controller
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@RestController
@RequestMapping("/api")
public class UploadController extends BaseController {

    // 文件上传路径，可在application.properties中配置
    @Value("${upload.path:./upload}")
    private String uploadPath;

    // 访问URL前缀，可在application.properties中配置
    @Value("${upload.url-prefix:http://localhost:8080/upload}")
    private String uploadUrlPrefix;

    /**
     * 上传文件
     *
     * @param file 上传的文件
     * @return 上传结果
     */
    @PostMapping("/upload")
    public Result uploadFile(@RequestParam("file") MultipartFile file) {
        if (file.isEmpty()) {
            return error(400, "上传文件不能为空");
        }

        try {
            // 1. 创建上传目录
            File uploadDir = new File(uploadPath);
            if (!uploadDir.exists()) {
                uploadDir.mkdirs();
            }

            // 2. 生成唯一文件名
            String originalFilename = file.getOriginalFilename();
            String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
            String fileName = UUID.randomUUID().toString() + suffix;

            // 3. 创建日期子目录
            String datePath = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
            File dateDir = new File(uploadDir, datePath);
            if (!dateDir.exists()) {
                dateDir.mkdirs();
            }

            // 4. 保存文件
            File destFile = new File(dateDir, fileName);
            file.transferTo(destFile);

            // 5. 生成访问URL
            String fileUrl = uploadUrlPrefix + "/" + datePath + "/" + fileName;

            return success(fileUrl);
        } catch (IOException e) {
            e.printStackTrace();
            return error(500, "文件上传失败：" + e.getMessage());
        }
    }
}
