package com.shiguangjianke.smartfoodsystem.controller;

/**
 * 统一响应结果类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
public class Result {
    
    /**
     * 响应状态码
     */
    private int code;
    
    /**
     * 响应消息
     */
    private String message;
    
    /**
     * 响应数据
     */
    private Object data;
    
    // 构造方法
    private Result(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }
    
    // 成功响应
    public static Result success(Object data) {
        return new Result(200, "成功", data);
    }
    
    // 成功响应，无数据
    public static Result success() {
        return new Result(200, "成功", null);
    }
    
    // 错误响应
    public static Result error(int code, String message) {
        return new Result(code, message, null);
    }
    
    // 错误响应，使用默认错误码
    public static Result error(String message) {
        return new Result(500, message, null);
    }
    
    // getter和setter方法
    public int getCode() {
        return code;
    }
    
    public void setCode(int code) {
        this.code = code;
    }
    
    public String getMessage() {
        return message;
    }
    
    public void setMessage(String message) {
        this.message = message;
    }
    
    public Object getData() {
        return data;
    }
    
    public void setData(Object data) {
        this.data = data;
    }
}
