package com.shiguangjianke.smartfoodsystem.controller;

import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 商家Controller
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@RestController
@RequestMapping("/api/merchant")
public class MerchantController extends BaseController {

    @Autowired
    private UserService userService;

    /**
     * 获取商家信息
     *
     * @param id 商家ID
     * @return 商家信息
     */
    @GetMapping("/info")
    public Result getMerchantInfo(@RequestParam Long id) {
        User user = userService.getById(id);
        if (user == null || user.getUserType() != 2) {
            return error(404, "商家不存在");
        }
        return success(user);
    }

    /**
     * 更新商家信息
     *
     * @param user 商家信息
     * @return 更新结果
     */
    @PutMapping("/update")
    public Result updateMerchant(@RequestBody User user) {
        // 确保只能更新商家信息
        user.setUserType(2);
        boolean result = userService.updateById(user);
        if (result) {
            return success("更新成功");
        } else {
            return error("更新失败");
        }
    }
}