package com.shiguangjianke.smartfoodsystem.controller;

import org.springframework.web.bind.annotation.RestController;

/**
 * 基础Controller
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@RestController
public class BaseController {
    
    /**
     * 成功响应
     *
     * @param data 响应数据
     * @return 响应结果
     */
    protected Result success(Object data) {
        return Result.success(data);
    }
    
    /**
     * 成功响应，无数据
     *
     * @return 响应结果
     */
    protected Result success() {
        return Result.success();
    }
    
    /**
     * 错误响应
     *
     * @param code 错误码
     * @param message 错误信息
     * @return 响应结果
     */
    protected Result error(int code, String message) {
        return Result.error(code, message);
    }
    
    /**
     * 错误响应，使用默认错误码
     *
     * @param message 错误信息
     * @return 响应结果
     */
    protected Result error(String message) {
        return Result.error(message);
    }
}
