package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.shiguangjianke.smartfoodsystem.entity.*;
import com.shiguangjianke.smartfoodsystem.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 管理端首页Controller
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@RestController
@RequestMapping("/api/admin/dashboard")
public class AdminDashboardController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private StoreService storeService;

    @Autowired
    private OrderService orderService;

    @Autowired
    private EvaluationService evaluationService;

    @Autowired
    private FeedbackService feedbackService;

    @Autowired
    private DishService dishService;

    /**
     * 获取平台统计概览数据
     *
     * @return 平台统计数据
     */
    @GetMapping("/overview")
    public Result getOverviewStatistics() {
        Map<String, Object> result = new HashMap<>();

        // 商家总数（user_type=2）
        QueryWrapper<User> merchantQuery = new QueryWrapper<>();
        merchantQuery.eq("user_type", 2);
        long merchantCount = userService.count(merchantQuery);
        result.put("merchantCount", merchantCount);

        // 店面总数
        long storeCount = storeService.count();
        result.put("storeCount", storeCount);

        // 菜品总数
        long dishCount = dishService.count();
        result.put("dishCount", dishCount);

        // 用户总数（user_type=1）
        QueryWrapper<User> userQuery = new QueryWrapper<>();
        userQuery.eq("user_type", 1);
        long userCount = userService.count(userQuery);
        result.put("userCount", userCount);

        // 订单总数
        long orderCount = orderService.count();
        result.put("orderCount", orderCount);

        // 评价总数
        long evaluationCount = evaluationService.count();
        result.put("evaluationCount", evaluationCount);

        // 反馈总数
        long feedbackCount = feedbackService.count();
        result.put("feedbackCount", feedbackCount);

        return success(result);
    }

    /**
     * 获取平台数据趋势
     *
     * @param timeRange 时间范围（week/month/quarter/year）
     * @return 数据趋势
     */
    @GetMapping("/trend")
    public Result getPlatformTrend(@RequestParam(defaultValue = "month") String timeRange) {
        // 这里可以根据时间范围查询不同的数据趋势
        // 示例数据，实际项目中应该从数据库查询
        List<String> dates = Arrays.asList("1日", "2日", "3日", "4日", "5日", "6日", "7日");
        List<Integer> newMerchants = Arrays.asList(12, 8, 15, 10, 20, 18, 25);
        List<Integer> newStores = Arrays.asList(20, 15, 25, 18, 30, 28, 40);
        List<Integer> newUsers = Arrays.asList(150, 120, 180, 160, 220, 200, 280);

        // 转换为前端图表所需的格式
        List<Map<String, Object>> trendList = new ArrayList<>();
        for (int i = 0; i < dates.size(); i++) {
            Map<String, Object> newMerchantItem = new HashMap<>();
            newMerchantItem.put("date", dates.get(i));
            newMerchantItem.put("value", newMerchants.get(i));
            newMerchantItem.put("type", "新商家");
            trendList.add(newMerchantItem);

            Map<String, Object> newStoreItem = new HashMap<>();
            newStoreItem.put("date", dates.get(i));
            newStoreItem.put("value", newStores.get(i));
            newStoreItem.put("type", "新店面");
            trendList.add(newStoreItem);

            Map<String, Object> newUserItem = new HashMap<>();
            newUserItem.put("date", dates.get(i));
            newUserItem.put("value", newUsers.get(i));
            newUserItem.put("type", "新用户");
            trendList.add(newUserItem);
        }

        return success(trendList);
    }

    /**
     * 获取最新动态
     *
     * @param limit 限制数量
     * @return 最新动态列表
     */
    @GetMapping("/latest-activities")
    public Result getLatestActivities(@RequestParam(defaultValue = "10") Integer limit) {
        // 这里可以查询最新的商家入驻、店面审核、评价等动态
        // 示例数据，实际项目中应该从数据库查询
        List<Map<String, Object>> activities = new ArrayList<>();
        activities.add(createActivity("商家入驻", "张三", "2024-07-28 10:30", "申请成为商家"));
        activities.add(createActivity("店面审核", "李四", "2024-07-28 09:15", "提交了新店面申请"));
        activities.add(createActivity("评价审核", "王五", "2024-07-27 16:45", "发布了新评价"));
        activities.add(createActivity("商家入驻", "赵六", "2024-07-27 14:20", "申请成为商家"));
        activities.add(createActivity("反馈处理", "孙七", "2024-07-27 11:10", "提交了反馈意见"));

        return success(activities);
    }

    /**
     * 获取最新反馈
     *
     * @return 最新反馈列表
     */
    @GetMapping("/latest-feedbacks")
    public Result getLatestFeedbacks() {
        // 示例数据，实际项目中应该从数据库查询
        List<Map<String, Object>> feedbacks = new ArrayList<>();
        feedbacks.add(createFeedbackItem(1L, "平台使用体验良好", "2024-07-28 10:30", "用户1234", "已处理"));
        feedbacks.add(createFeedbackItem(2L, "希望增加更多支付方式", "2024-07-28 09:15", "用户5678", "处理中"));
        feedbacks.add(createFeedbackItem(3L, "商家入驻流程可以简化", "2024-07-27 16:45", "用户9012", "待处理"));
        feedbacks.add(createFeedbackItem(4L, "评价功能建议优化", "2024-07-27 14:20", "用户3456", "已处理"));
        feedbacks.add(createFeedbackItem(5L, "系统响应速度很快", "2024-07-27 11:10", "用户7890", "已处理"));

        return success(feedbacks);
    }

    /**
     * 创建反馈项
     */
    private Map<String, Object> createFeedbackItem(Long id, String content, String createTime, String username, String status) {
        Map<String, Object> item = new HashMap<>();
        item.put("id", id);
        item.put("title", "用户反馈"); // 前端需要title字段
        item.put("content", content);
        item.put("createTime", createTime);
        item.put("username", username);
        item.put("status", status); // 前端需要status字段
        return item;
    }

    /**
     * 获取商家活跃度
     *
     * @return 商家活跃度数据
     */
    @GetMapping("/activity")
    public Result getMerchantActivity() {
        // 示例数据，实际项目中应该从数据库查询
        List<String> merchantNames = Arrays.asList("商家A", "商家B", "商家C", "商家D", "商家E");
        List<Integer> activityValues = Arrays.asList(85, 70, 90, 65, 80);

        // 转换为前端图表所需的格式
        List<Map<String, Object>> activityList = new ArrayList<>();
        for (int i = 0; i < merchantNames.size(); i++) {
            Map<String, Object> item = new HashMap<>();
            item.put("name", merchantNames.get(i));
            item.put("activeDays", activityValues.get(i));
            activityList.add(item);
        }

        return success(activityList);
    }

    /**
     * 创建动态项
     */
    private Map<String, Object> createActivity(String type, String username, String time, String content) {
        Map<String, Object> activity = new HashMap<>();
        activity.put("type", type);
        activity.put("username", username);
        activity.put("time", time);
        activity.put("content", content);
        return activity;
    }
}