package com.shiguangjianke.smartfoodsystem;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;

/**
 * "食光荐客"食堂店面推荐平台主启动类
 *
 * @author shiguangjianke
 * @since 2024-07-28
 */
@SpringBootApplication
@MapperScan("com.shiguangjianke.smartfoodsystem.mapper")
@EnableCaching
public class SmartFoodSystemApplication {

    public static void main(String[] args) {
        SpringApplication.run(SmartFoodSystemApplication.class, args);
        System.out.println("\n\n==============================================");
        System.out.println("\"食光荐客\"食堂店面推荐平台启动成功！");
        System.out.println("访问地址: http://localhost:8080/api");
        System.out.println("==============================================\n\n");
    }

}