import { createRouter, createWebHistory } from 'vue-router'

// 公共路由
const publicRoutes = [
  {
    path: '/login',
    name: 'Login',
    component: () => import('../views/auth/Login.vue')
  },
  {
    path: '/register',
    name: 'Register',
    component: () => import('../views/auth/Register.vue')
  },
  {
    path: '/',
    redirect: '/login'
  },
  {
    path: '/app',
    name: 'Layout',
    component: () => import('../layout/Layout.vue'),
    redirect: (to) => {
      // 获取用户信息
      let user = {};
      try {
        const userStr = localStorage.getItem('user');
        user = userStr ? JSON.parse(userStr) : {};
      } catch (error) {
        console.error('解析用户信息失败:', error);
        user = {};
      }
      
      // 根据用户角色重定向到不同页面
      if (user.role === 'admin') {
        return '/app/admin/dashboard';
      } else if (user.role === 'merchant') {
        return '/app/merchant/dashboard';
      } else {
        // 默认重定向到店面列表页
        return '/app/store';
      }
    },
    children: [


      // 管理员相关路由
      {
        path: 'admin/dashboard',
        name: 'AdminDashboard',
        component: () => import('../views/admin/Dashboard.vue')
      },
      {		path: 'admin/store-management',		name: 'AdminStoreManagement',		component: () => import('../views/admin/StoreManagement.vue')	  },
      {
        path: 'admin/feedback-management',
        name: 'FeedbackManagement',
        component: () => import('../views/admin/FeedbackManagement.vue')
      },
      {
        path: 'admin/evaluation-supervision',
        name: 'EvaluationSupervision',
        component: () => import('../views/admin/EvaluationSupervision.vue')
      },
      {
        path: 'admin/data-report',
        name: 'DataReport',
        component: () => import('../views/admin/DataReport.vue')
      },
      {
        path: 'admin/system-management',
        name: 'SystemManagement',
        component: () => import('../views/admin/SystemManagement.vue')
      },
      // 用户端相关路由
      {
        path: 'store',
        name: 'StoreList',
        component: () => import('../views/store/StoreList.vue')
      },
      {
        path: 'store/:id',
        name: 'StoreDetail',
        component: () => import('../views/store/StoreDetail.vue')
      },
      {
        path: 'store/:storeId/dish/:id',
        name: 'DishDetail',
        component: () => import('../views/store/DishDetail.vue')
      },
      {
        path: 'feedback',
        name: 'Feedback',
        component: () => import('../views/feedback/Feedback.vue')
      },
      {
        path: 'favorite',
        name: 'FavoriteList',
        component: () => import('../views/favorite/FavoriteList.vue')
      },
      {
        path: 'personal',
        name: 'PersonalCenter',
        component: () => import('../views/personal/PersonalCenter.vue')
      },
      
      // 管理员相关路由
      {
        path: 'admin/dashboard',
        name: 'AdminDashboard',
        component: () => import('../views/admin/Dashboard.vue')
      },
      {		path: 'admin/store-management',		name: 'AdminStoreManagement',		component: () => import('../views/admin/StoreManagement.vue')	  },
      {
        path: 'admin/feedback-management',
        name: 'FeedbackManagement',
        component: () => import('../views/admin/FeedbackManagement.vue')
      },
      {
        path: 'admin/evaluation-supervision',
        name: 'EvaluationSupervision',
        component: () => import('../views/admin/EvaluationSupervision.vue')
      },
      {
        path: 'admin/data-report',
        name: 'DataReport',
        component: () => import('../views/admin/DataReport.vue')
      },
      {
        path: 'admin/system-management',
        name: 'SystemManagement',
        component: () => import('../views/admin/SystemManagement.vue')
      },
      
      // 商家相关路由
      {
        path: 'merchant',
        name: 'MerchantCenter',
        redirect: '/app/merchant/dashboard'
      },
      {
        path: 'merchant/dashboard',
        name: 'MerchantDashboard',
        component: () => import('../views/merchant/Dashboard.vue')
      },
      {		path: 'merchant/store-management',		name: 'MerchantStoreManagement',		component: () => import('../views/merchant/StoreManagement.vue')	  },
      {
        path: 'merchant/dish-management',
        name: 'DishManagement',
        component: () => import('../views/merchant/DishManagement.vue')
      },
      {
        path: 'merchant/evaluation-management',
        name: 'EvaluationManagement',
        component: () => import('../views/merchant/EvaluationManagement.vue')
      },
      {
        path: 'merchant/data-statistics',
        name: 'DataStatistics',
        component: () => import('../views/merchant/DataStatistics.vue')
      },
      {
        path: 'merchant/message-notification',
        name: 'MessageNotification',
        component: () => import('../views/merchant/MessageNotification.vue')
      },
      {
        path: 'merchant/personal-center',
        name: 'MerchantPersonalCenter',
        component: () => import('../views/merchant/PersonalCenter.vue')
      },

    ]
  }
]

// 创建路由实例
const router = createRouter({
  history: createWebHistory(),
  routes: [...publicRoutes]
})

// 路由守卫
router.beforeEach((to, from, next) => {
  // 获取本地存储的用户信息，处理可能为null的情况
  let user = {}
  try {
    const userStr = localStorage.getItem('user')
    user = userStr ? JSON.parse(userStr) : {}
  } catch (error) {
    console.error('解析用户信息失败:', error)
    user = {}
  }
  
  // 定义需要登录的路由路径
  const requiresAuth = to.path.startsWith('/app')
  
  // 如果访问需要登录的页面且未登录，则跳转到登录页
  if (requiresAuth && (!user || !user.id)) {
    next('/login')
  } else {
    next()
  }
})

export default router