'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var slider = require('../props/slider.js');
var useSlider = require('../composables/use-slider.js');
var pluginVue_exportHelper = require('../../../../_virtual/plugin-vue_export-helper.js');
var index = require('../../../../hooks/use-locale/index.js');

const minValue = 0;
const maxValue = 360;
const __default__ = vue.defineComponent({
  name: "ElColorHueSlider"
});
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: slider.hueSliderProps,
  setup(__props, { expose }) {
    const props = __props;
    const { currentValue, bar, thumb, handleDrag, handleClick, handleKeydown } = useSlider.useSlider(props, { key: "hue", minValue, maxValue });
    const { rootKls, barKls, thumbKls, thumbStyle, thumbTop, update } = useSlider.useSliderDOM(props, {
      namespace: "color-hue-slider",
      maxValue,
      currentValue,
      bar,
      thumb,
      handleDrag
    });
    const { t } = index.useLocale();
    const ariaLabel = vue.computed(() => t("el.colorpicker.hueLabel"));
    const ariaValuetext = vue.computed(() => {
      return t("el.colorpicker.hueDescription", {
        hue: currentValue.value,
        color: props.color.value
      });
    });
    expose({
      bar,
      thumb,
      thumbTop,
      update
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("div", {
        class: vue.normalizeClass(vue.unref(rootKls))
      }, [
        vue.createElementVNode("div", {
          ref_key: "bar",
          ref: bar,
          class: vue.normalizeClass(vue.unref(barKls)),
          onClick: vue.unref(handleClick)
        }, null, 10, ["onClick"]),
        vue.createElementVNode("div", {
          ref_key: "thumb",
          ref: thumb,
          class: vue.normalizeClass(vue.unref(thumbKls)),
          style: vue.normalizeStyle(vue.unref(thumbStyle)),
          "aria-label": vue.unref(ariaLabel),
          "aria-valuenow": vue.unref(currentValue),
          "aria-valuetext": vue.unref(ariaValuetext),
          "aria-orientation": _ctx.vertical ? "vertical" : "horizontal",
          "aria-valuemin": minValue,
          "aria-valuemax": maxValue,
          role: "slider",
          tabindex: "0",
          onKeydown: vue.unref(handleKeydown)
        }, null, 46, ["aria-label", "aria-valuenow", "aria-valuetext", "aria-orientation", "onKeydown"])
      ], 2);
    };
  }
});
var HueSlider = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["__file", "hue-slider.vue"]]);

exports["default"] = HueSlider;
//# sourceMappingURL=hue-slider.js.map
