import { defineComponent, computed, openBlock, createElementBlock, normalizeClass, unref, createElementVNode, normalizeStyle } from 'vue';
import { hueSliderProps } from '../props/slider.mjs';
import { useSlider, useSliderDOM } from '../composables/use-slider.mjs';
import _export_sfc from '../../../../_virtual/plugin-vue_export-helper.mjs';
import { useLocale } from '../../../../hooks/use-locale/index.mjs';

const minValue = 0;
const maxValue = 360;
const __default__ = defineComponent({
  name: "ElColorHueSlider"
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: hueSliderProps,
  setup(__props, { expose }) {
    const props = __props;
    const { currentValue, bar, thumb, handleDrag, handleClick, handleKeydown } = useSlider(props, { key: "hue", minValue, maxValue });
    const { rootKls, barKls, thumbKls, thumbStyle, thumbTop, update } = useSliderDOM(props, {
      namespace: "color-hue-slider",
      maxValue,
      currentValue,
      bar,
      thumb,
      handleDrag
    });
    const { t } = useLocale();
    const ariaLabel = computed(() => t("el.colorpicker.hueLabel"));
    const ariaValuetext = computed(() => {
      return t("el.colorpicker.hueDescription", {
        hue: currentValue.value,
        color: props.color.value
      });
    });
    expose({
      bar,
      thumb,
      thumbTop,
      update
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(unref(rootKls))
      }, [
        createElementVNode("div", {
          ref_key: "bar",
          ref: bar,
          class: normalizeClass(unref(barKls)),
          onClick: unref(handleClick)
        }, null, 10, ["onClick"]),
        createElementVNode("div", {
          ref_key: "thumb",
          ref: thumb,
          class: normalizeClass(unref(thumbKls)),
          style: normalizeStyle(unref(thumbStyle)),
          "aria-label": unref(ariaLabel),
          "aria-valuenow": unref(currentValue),
          "aria-valuetext": unref(ariaValuetext),
          "aria-orientation": _ctx.vertical ? "vertical" : "horizontal",
          "aria-valuemin": minValue,
          "aria-valuemax": maxValue,
          role: "slider",
          tabindex: "0",
          onKeydown: unref(handleKeydown)
        }, null, 46, ["aria-label", "aria-valuenow", "aria-valuetext", "aria-orientation", "onKeydown"])
      ], 2);
    };
  }
});
var HueSlider = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "hue-slider.vue"]]);

export { HueSlider as default };
//# sourceMappingURL=hue-slider.mjs.map
