import { defineComponent, computed, openBlock, createElementBlock, normalizeClass, unref, createElementVNode, normalizeStyle } from 'vue';
import { alphaSliderProps } from '../props/slider.mjs';
import { useSlider, useSliderDOM } from '../composables/use-slider.mjs';
import _export_sfc from '../../../../_virtual/plugin-vue_export-helper.mjs';
import { useLocale } from '../../../../hooks/use-locale/index.mjs';

const minValue = 0;
const maxValue = 100;
const __default__ = defineComponent({
  name: "ElColorAlphaSlider"
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: alphaSliderProps,
  setup(__props, { expose }) {
    const props = __props;
    const { currentValue, bar, thumb, handleDrag, handleClick, handleKeydown } = useSlider(props, { key: "alpha", minValue, maxValue });
    const { rootKls, barKls, barStyle, thumbKls, thumbStyle, update } = useSliderDOM(props, {
      namespace: "color-alpha-slider",
      maxValue,
      currentValue,
      bar,
      thumb,
      handleDrag,
      getBackground
    });
    const { t } = useLocale();
    const ariaLabel = computed(() => t("el.colorpicker.alphaLabel"));
    const ariaValuetext = computed(() => {
      return t("el.colorpicker.alphaDescription", {
        alpha: currentValue.value,
        color: props.color.value
      });
    });
    function getBackground() {
      if (props.color && props.color.value) {
        const { r, g, b } = props.color.toRgb();
        return `linear-gradient(to right, rgba(${r}, ${g}, ${b}, 0) 0%, rgba(${r}, ${g}, ${b}, 1) 100%)`;
      }
      return "";
    }
    expose({
      update,
      bar,
      thumb
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(unref(rootKls))
      }, [
        createElementVNode("div", {
          ref_key: "bar",
          ref: bar,
          class: normalizeClass(unref(barKls)),
          style: normalizeStyle(unref(barStyle)),
          onClick: unref(handleClick)
        }, null, 14, ["onClick"]),
        createElementVNode("div", {
          ref_key: "thumb",
          ref: thumb,
          class: normalizeClass(unref(thumbKls)),
          style: normalizeStyle(unref(thumbStyle)),
          "aria-label": unref(ariaLabel),
          "aria-valuenow": unref(currentValue),
          "aria-valuetext": unref(ariaValuetext),
          "aria-orientation": _ctx.vertical ? "vertical" : "horizontal",
          "aria-valuemin": minValue,
          "aria-valuemax": maxValue,
          role: "slider",
          tabindex: "0",
          onKeydown: unref(handleKeydown)
        }, null, 46, ["aria-label", "aria-valuenow", "aria-valuetext", "aria-orientation", "onKeydown"])
      ], 2);
    };
  }
});
var AlphaSlider = /* @__PURE__ */ _export_sfc(_sfc_main, [["__file", "alpha-slider.vue"]]);

export { AlphaSlider as default };
//# sourceMappingURL=alpha-slider.mjs.map
