/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplListInt64;
import com.alibaba.fastjson2.reader.ObjectReaderImplListStr;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

public final class ObjectReaderImplList
implements ObjectReader {
    static final Class CLASS_EMPTY_SET = Collections.emptySet().getClass();
    static final Class CLASS_EMPTY_LIST = Collections.emptyList().getClass();
    static final Class CLASS_SINGLETON = Collections.singleton(0).getClass();
    static final Class CLASS_SINGLETON_LIST = Collections.singletonList(0).getClass();
    static final Class CLASS_ARRAYS_LIST = Arrays.asList(0).getClass();
    static final Class CLASS_UNMODIFIABLE_COLLECTION = Collections.unmodifiableCollection(Collections.emptyList()).getClass();
    static final Class CLASS_UNMODIFIABLE_LIST = Collections.unmodifiableList(Collections.emptyList()).getClass();
    static final Class CLASS_UNMODIFIABLE_SET = Collections.unmodifiableSet(Collections.emptySet()).getClass();
    static final Class CLASS_UNMODIFIABLE_SORTED_SET = Collections.unmodifiableSortedSet(Collections.emptySortedSet()).getClass();
    static final Class CLASS_UNMODIFIABLE_NAVIGABLE_SET = Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()).getClass();
    public static ObjectReaderImplList INSTANCE = new ObjectReaderImplList((Type)((Object)ArrayList.class), ArrayList.class, ArrayList.class, (Type)((Object)Object.class), null);
    final Type listType;
    final Class listClass;
    final Class instanceType;
    final long instanceTypeHash;
    final Type itemType;
    final Class itemClass;
    final String itemClassName;
    final long itemClassNameHash;
    final Function builder;
    ObjectReader itemObjectReader;
    volatile boolean instanceError;

    public static ObjectReader of(Type type, Class listClass, long features) {
        Class instanceClass;
        Type rawType;
        if (listClass == type && "".equals(listClass.getSimpleName())) {
            type = listClass.getGenericSuperclass();
            listClass = listClass.getSuperclass();
        }
        Object itemType = Object.class;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 1) {
                itemType = actualTypeArguments[0];
            }
        } else {
            Type superType;
            rawType = type;
            if (listClass != null && (superType = listClass.getGenericSuperclass()) instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)superType;
                rawType = parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length == 1) {
                    itemType = actualTypeArguments[0];
                }
            }
        }
        if (listClass == null) {
            listClass = TypeUtils.getClass(rawType);
        }
        Function builder = null;
        if (listClass == Iterable.class || listClass == Collection.class || listClass == List.class || listClass == AbstractCollection.class || listClass == AbstractList.class) {
            instanceClass = ArrayList.class;
        } else if (listClass == Queue.class || listClass == Deque.class || listClass == AbstractSequentialList.class) {
            instanceClass = LinkedList.class;
        } else if (listClass == Set.class || listClass == AbstractSet.class) {
            instanceClass = HashSet.class;
        } else if (listClass == EnumSet.class) {
            instanceClass = HashSet.class;
            builder = o -> EnumSet.copyOf((Collection)o);
        } else if (listClass == NavigableSet.class || listClass == SortedSet.class) {
            instanceClass = TreeSet.class;
        } else if (listClass == CLASS_SINGLETON) {
            instanceClass = ArrayList.class;
            builder = obj -> Collections.singleton(((List)obj).get(0));
        } else if (listClass == CLASS_SINGLETON_LIST) {
            instanceClass = ArrayList.class;
            builder = obj -> Collections.singletonList(((List)obj).get(0));
        } else if (listClass == CLASS_ARRAYS_LIST) {
            instanceClass = ArrayList.class;
            builder = obj -> Arrays.asList(((List)obj).toArray());
        } else if (listClass == CLASS_UNMODIFIABLE_COLLECTION) {
            instanceClass = ArrayList.class;
            builder = obj -> Collections.unmodifiableCollection((Collection)obj);
        } else if (listClass == CLASS_UNMODIFIABLE_LIST) {
            instanceClass = ArrayList.class;
            builder = obj -> Collections.unmodifiableList((List)obj);
        } else if (listClass == CLASS_UNMODIFIABLE_SET) {
            instanceClass = LinkedHashSet.class;
            builder = obj -> Collections.unmodifiableSet((Set)obj);
        } else if (listClass == CLASS_UNMODIFIABLE_SORTED_SET) {
            instanceClass = TreeSet.class;
            builder = obj -> Collections.unmodifiableSortedSet((SortedSet)obj);
        } else if (listClass == CLASS_UNMODIFIABLE_NAVIGABLE_SET) {
            instanceClass = TreeSet.class;
            builder = obj -> Collections.unmodifiableNavigableSet((NavigableSet)obj);
        } else {
            String typeName;
            switch (typeName = listClass.getTypeName()) {
                case "com.google.common.collect.ImmutableList": 
                case "com.google.common.collect.SingletonImmutableList": 
                case "com.google.common.collect.RegularImmutableList": 
                case "com.google.common.collect.AbstractMapBasedMultimap$RandomAccessWrappedList": {
                    instanceClass = ArrayList.class;
                    builder = GuavaSupport.immutableListConverter();
                    break;
                }
                case "com.google.common.collect.ImmutableSet": 
                case "com.google.common.collect.SingletonImmutableSet": 
                case "com.google.common.collect.RegularImmutableSet": {
                    instanceClass = ArrayList.class;
                    builder = GuavaSupport.immutableSetConverter();
                    break;
                }
                case "com.google.common.collect.Lists$TransformingRandomAccessList": {
                    instanceClass = ArrayList.class;
                    break;
                }
                case "com.google.common.collect.Lists.TransformingSequentialList": {
                    instanceClass = LinkedList.class;
                    break;
                }
                case "java.util.Collections$SynchronizedRandomAccessList": {
                    instanceClass = ArrayList.class;
                    builder = Collections::synchronizedList;
                    break;
                }
                case "java.util.Collections$SynchronizedCollection": {
                    instanceClass = ArrayList.class;
                    builder = Collections::synchronizedCollection;
                    break;
                }
                case "java.util.Collections$SynchronizedSet": {
                    instanceClass = HashSet.class;
                    builder = Collections::synchronizedSet;
                    break;
                }
                case "java.util.Collections$SynchronizedSortedSet": {
                    instanceClass = TreeSet.class;
                    builder = Collections::synchronizedSortedSet;
                    break;
                }
                case "java.util.Collections$SynchronizedNavigableSet": {
                    instanceClass = TreeSet.class;
                    builder = Collections::synchronizedNavigableSet;
                    break;
                }
                default: {
                    instanceClass = listClass;
                }
            }
        }
        if (type == CLASS_EMPTY_SET || type == CLASS_EMPTY_LIST || type == CLASS_EMPTY_LIST) {
            return new ObjectReaderImplList(type, (Class)type, (Class)type, (Type)((Object)Object.class), null);
        }
        if (itemType == String.class && builder == null) {
            return new ObjectReaderImplListStr(listClass, instanceClass);
        }
        if (itemType == Long.class && builder == null) {
            return new ObjectReaderImplListInt64(listClass, instanceClass);
        }
        return new ObjectReaderImplList(type, listClass, instanceClass, (Type)itemType, builder);
    }

    public ObjectReaderImplList(Type listType, Class listClass, Class instanceType, Type itemType, Function builder) {
        this.listType = listType;
        this.listClass = listClass;
        this.instanceType = instanceType;
        this.instanceTypeHash = Fnv.hashCode64(TypeUtils.getTypeName(instanceType));
        this.itemType = itemType;
        this.itemClass = TypeUtils.getClass(itemType);
        this.builder = builder;
        this.itemClassName = this.itemClass != null ? TypeUtils.getTypeName(this.itemClass) : null;
        this.itemClassNameHash = this.itemClassName != null ? Fnv.hashCode64(this.itemClassName) : 0L;
    }

    public Class getObjectClass() {
        return this.listClass;
    }

    @Override
    public Function getBuildFunction() {
        return this.builder;
    }

    public Object createInstance(Collection collection) {
        int size = collection.size();
        if (size == 0 && this.listClass == List.class) {
            List list = Collections.emptyList();
            if (this.builder != null) {
                return this.builder.apply(list);
            }
            return list;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Collection list = (Collection)this.createInstance(0L);
        for (Object item : collection) {
            if (item == null) {
                list.add(null);
                continue;
            }
            Object value = item;
            Class<?> valueClass = value.getClass();
            if (valueClass != this.itemType) {
                Function typeConvert = provider.getTypeConvert(valueClass, this.itemType);
                if (typeConvert != null) {
                    value = typeConvert.apply(value);
                } else if (item instanceof Map) {
                    Map map = (Map)item;
                    if (this.itemObjectReader == null) {
                        this.itemObjectReader = provider.getObjectReader(this.itemType);
                    }
                    value = this.itemObjectReader.createInstance(map, 0L);
                } else if (value instanceof Collection) {
                    if (this.itemObjectReader == null) {
                        this.itemObjectReader = provider.getObjectReader(this.itemType);
                    }
                    value = this.itemObjectReader.createInstance((Collection)value);
                } else if (!this.itemClass.isInstance(value)) {
                    throw new JSONException("can not convert from " + valueClass + " to " + this.itemType);
                }
            }
            list.add(value);
        }
        if (this.builder != null) {
            return this.builder.apply(list);
        }
        return list;
    }

    public Object createInstance(long features) {
        if (this.instanceType == ArrayList.class) {
            return JDKUtils.JVM_VERSION == 8 ? new ArrayList(10) : new ArrayList();
        }
        if (this.instanceType == LinkedList.class) {
            return new LinkedList();
        }
        if (this.instanceType == HashSet.class) {
            return new HashSet();
        }
        if (this.instanceType == LinkedHashSet.class) {
            return new LinkedHashSet();
        }
        if (this.instanceType == TreeSet.class) {
            return new TreeSet();
        }
        if (this.instanceType == CLASS_EMPTY_LIST) {
            return Collections.emptyList();
        }
        if (this.instanceType == CLASS_EMPTY_SET) {
            return Collections.emptySet();
        }
        if (this.instanceType != null) {
            JSONException error = null;
            if (!this.instanceError) {
                try {
                    return this.instanceType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.instanceError = true;
                    error = new JSONException("create list error, type " + this.instanceType);
                }
            }
            if (this.instanceError && List.class.isAssignableFrom(this.instanceType.getSuperclass())) {
                try {
                    return this.instanceType.getSuperclass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.instanceError = true;
                    error = new JSONException("create list error, type " + this.instanceType);
                }
            }
            if (error != null) {
                throw error;
            }
        }
        return new ArrayList();
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Type[] actualTypeArguments;
        Collection<Object> list2;
        int entryCnt;
        ObjectReader objectReader = jsonReader.checkAutoType(this.listClass, 0L, features);
        Function<Object, Object> builder = this.builder;
        Class<Object> listType = this.instanceType;
        if (objectReader != null) {
            listType = objectReader.getObjectClass();
            if (listType == CLASS_UNMODIFIABLE_COLLECTION) {
                listType = ArrayList.class;
                builder = Collections::unmodifiableCollection;
            } else if (listType == CLASS_UNMODIFIABLE_LIST) {
                listType = ArrayList.class;
                builder = Collections::unmodifiableList;
            } else if (listType == CLASS_UNMODIFIABLE_SET) {
                listType = LinkedHashSet.class;
                builder = Collections::unmodifiableSet;
            } else if (listType == CLASS_UNMODIFIABLE_SORTED_SET) {
                listType = TreeSet.class;
                builder = Collections::unmodifiableSortedSet;
            } else if (listType == CLASS_UNMODIFIABLE_NAVIGABLE_SET) {
                listType = TreeSet.class;
                builder = Collections::unmodifiableNavigableSet;
            } else if (listType == CLASS_SINGLETON) {
                listType = ArrayList.class;
                builder = list -> Collections.singleton(list.iterator().next());
            } else if (listType == CLASS_SINGLETON_LIST) {
                listType = ArrayList.class;
                builder = list -> Collections.singletonList(list.get(0));
            }
        }
        if ((entryCnt = jsonReader.startArray()) > 0 && this.itemObjectReader == null) {
            this.itemObjectReader = jsonReader.getContext().getObjectReader(this.itemType);
        }
        if (listType == CLASS_ARRAYS_LIST) {
            Object[] array = new Object[entryCnt];
            List<Object> list3 = Arrays.asList(array);
            for (int i = 0; i < entryCnt; ++i) {
                List<Object> item;
                if (jsonReader.isReference()) {
                    String reference = jsonReader.readReference();
                    if ("..".equals(reference)) {
                        item = list3;
                    } else {
                        item = null;
                        jsonReader.addResolveTask(list3, i, JSONPath.of(reference));
                    }
                } else {
                    item = this.itemObjectReader.readJSONBObject(jsonReader, this.itemType, i, features);
                }
                array[i] = item;
            }
            return list3;
        }
        if (listType == ArrayList.class) {
            list2 = entryCnt > 0 ? new ArrayList(entryCnt) : new ArrayList();
        } else if (listType == JSONArray.class) {
            list2 = entryCnt > 0 ? new JSONArray(entryCnt) : new JSONArray();
        } else if (listType == HashSet.class) {
            list2 = new HashSet();
        } else if (listType == LinkedHashSet.class) {
            list2 = new LinkedHashSet();
        } else if (listType == TreeSet.class) {
            list2 = new TreeSet();
        } else if (listType == CLASS_EMPTY_SET) {
            list2 = Collections.emptySet();
        } else if (listType == CLASS_EMPTY_LIST) {
            list2 = Collections.emptyList();
        } else if (listType == CLASS_SINGLETON_LIST) {
            list2 = new ArrayList();
            builder = items -> Collections.singletonList(items.iterator().next());
        } else if (listType == CLASS_UNMODIFIABLE_LIST) {
            list2 = new ArrayList();
            builder = items -> Collections.unmodifiableList(items);
        } else if (listType != null && EnumSet.class.isAssignableFrom(listType)) {
            list2 = new HashSet();
            builder = o -> EnumSet.copyOf((Collection)o);
        } else if (listType != null && listType != this.listType) {
            try {
                list2 = (Collection)listType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error " + listType), e);
            }
        } else {
            list2 = (Collection)this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        ObjectReader itemObjectReader = this.itemObjectReader;
        Type itemType = this.itemType;
        if (fieldType != null && fieldType != listType && fieldType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments()).length == 1 && (itemType = actualTypeArguments[0]) != this.itemType) {
            itemObjectReader = jsonReader.getObjectReader(itemType);
        }
        for (int i = 0; i < entryCnt; ++i) {
            Collection<Object> item;
            if (jsonReader.isReference()) {
                String reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    item = list2;
                } else {
                    jsonReader.addResolveTask(list2, i, JSONPath.of(reference));
                    if (!(list2 instanceof List)) continue;
                    item = null;
                }
            } else {
                ObjectReader autoTypeReader = jsonReader.checkAutoType(this.itemClass, this.itemClassNameHash, features);
                item = autoTypeReader != null ? autoTypeReader.readJSONBObject(jsonReader, itemType, i, features) : itemObjectReader.readJSONBObject(jsonReader, itemType, i, features);
            }
            list2.add(item);
        }
        if (builder != null) {
            return builder.apply(list2);
        }
        return list2;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Type[] actualTypeArguments;
        JSONReader.Context context = jsonReader.getContext();
        if (this.itemObjectReader == null) {
            this.itemObjectReader = context.getObjectReader(this.itemType);
        }
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        Collection list = jsonReader.nextIfSet() ? new HashSet() : (Collection)this.createInstance(context.getFeatures() | features);
        char ch = jsonReader.current();
        if (ch == '\"') {
            String str = jsonReader.readString();
            if (this.itemClass == String.class) {
                jsonReader.nextIfMatch(',');
                list.add(str);
                return list;
            }
            if (str.isEmpty()) {
                jsonReader.nextIfMatch(',');
                return null;
            }
            Function typeConvert = context.getProvider().getTypeConvert((Type)((Object)String.class), this.itemType);
            if (typeConvert != null) {
                Object converted = typeConvert.apply(str);
                jsonReader.nextIfMatch(',');
                list.add(converted);
                return list;
            }
            throw new JSONException(jsonReader.info());
        }
        if (ch != '[') {
            if (this.itemClass != Object.class && this.itemObjectReader != null || this.itemClass == Object.class && jsonReader.isObject()) {
                Object item = this.itemObjectReader.readObject(jsonReader, this.itemType, 0, 0L);
                list.add(item);
                if (this.builder != null) {
                    list = (Collection)this.builder.apply(list);
                }
                return list;
            }
            throw new JSONException(jsonReader.info());
        }
        jsonReader.next();
        ObjectReader itemObjectReader = this.itemObjectReader;
        Type itemType = this.itemType;
        if (fieldType != null && fieldType != this.listType && fieldType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments()).length == 1 && (itemType = actualTypeArguments[0]) != this.itemType) {
            itemObjectReader = jsonReader.getObjectReader(itemType);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch(']')) {
            block19: {
                Object item;
                block15: {
                    block16: {
                        block17: {
                            String reference;
                            block18: {
                                block14: {
                                    if (itemType != String.class) break block14;
                                    item = jsonReader.readString();
                                    break block15;
                                }
                                if (itemObjectReader == null) break block16;
                                if (!jsonReader.isReference()) break block17;
                                reference = jsonReader.readReference();
                                if (!"..".equals(reference)) break block18;
                                item = this;
                                break block15;
                            }
                            jsonReader.addResolveTask(list, i, JSONPath.of(reference));
                            break block19;
                        }
                        item = itemObjectReader.readObject(jsonReader, itemType, i, 0L);
                        break block15;
                    }
                    throw new JSONException(jsonReader.info("TODO : " + itemType));
                }
                list.add(item);
                if (jsonReader.nextIfMatch(',')) {
                    // empty if block
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.builder != null) {
            return this.builder.apply(list);
        }
        return list;
    }
}

