/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.util.JDKUtils;

final class JSONWriterUTF8JDK9
extends JSONWriterUTF8 {
    JSONWriterUTF8JDK9(JSONWriter.Context ctx) {
        super(ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeString(String str) {
        if (JDKUtils.STRING_VALUE == null) {
            super.writeString(str);
            return;
        }
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        int coder = JDKUtils.STRING_CODER.applyAsInt(str);
        byte[] value = JDKUtils.STRING_VALUE.apply(str);
        if (coder == 0) {
            this.writeStringLatin1(value);
            return;
        }
        boolean escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        int minCapacity = this.off + value.length * 4 + 2;
        if (escapeNoneAscii) {
            minCapacity += value.length * 2;
        }
        if (minCapacity - this.bytes.length > 0) {
            this.ensureCapacity(minCapacity);
        }
        this.bytes[this.off++] = (byte)this.quote;
        int valueOffset = 0;
        block12: while (true) {
            int c;
            block31: {
                int uc;
                block30: {
                    block32: {
                        byte b1;
                        if (valueOffset >= value.length) {
                            this.bytes[this.off++] = (byte)this.quote;
                            return;
                        }
                        byte b0 = value[valueOffset++];
                        if ((b1 = value[valueOffset++]) == 0 && b0 >= 0) {
                            byte ch = b0;
                            switch (ch) {
                                case 92: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 92;
                                    continue block12;
                                }
                                case 10: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 110;
                                    continue block12;
                                }
                                case 13: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 114;
                                    continue block12;
                                }
                                case 12: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 102;
                                    continue block12;
                                }
                                case 8: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 98;
                                    continue block12;
                                }
                                case 9: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 116;
                                    continue block12;
                                }
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = (byte)(48 + ch);
                                    continue block12;
                                }
                                case 11: 
                                case 14: 
                                case 15: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                    continue block12;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 49;
                                    this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                    continue block12;
                                }
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 49;
                                    this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                    continue block12;
                                }
                            }
                            if (ch == this.quote) {
                                this.bytes[this.off++] = 92;
                                this.bytes[this.off++] = (byte)this.quote;
                                continue;
                            }
                            this.bytes[this.off++] = ch;
                            continue;
                        }
                        c = (b0 & 0xFF) << 0 | (b1 & 0xFF) << 8;
                        if (c < 2048) {
                            this.bytes[this.off++] = (byte)(0xC0 | c >> 6);
                            this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
                            continue;
                        }
                        if (escapeNoneAscii) {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 117;
                            this.bytes[this.off++] = (byte)DIGITS[c >>> 12 & 0xF];
                            this.bytes[this.off++] = (byte)DIGITS[c >>> 8 & 0xF];
                            this.bytes[this.off++] = (byte)DIGITS[c >>> 4 & 0xF];
                            this.bytes[this.off++] = (byte)DIGITS[c & 0xF];
                            continue;
                        }
                        if (c < 55296 || c >= 57344) break block31;
                        int ip = valueOffset - 1;
                        if (c < 55296 || c >= 56320) break block32;
                        if (value.length - ip < 2) {
                            uc = -1;
                            break block30;
                        } else {
                            b0 = value[ip + 1];
                            b1 = value[ip + 2];
                            char d = (char)((b0 & 0xFF) << 0 | (b1 & 0xFF) << 8);
                            if (d >= '\udc00' && d < '\ue000') {
                                valueOffset += 2;
                                uc = (c << 10) + d + -56613888;
                                break block30;
                            } else {
                                this.bytes[this.off++] = 63;
                                continue;
                            }
                        }
                    }
                    if (c >= 56320 && c < 57344) {
                        this.bytes[this.off++] = 63;
                        continue;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    this.bytes[this.off++] = 63;
                    continue;
                }
                this.bytes[this.off++] = (byte)(0xF0 | uc >> 18);
                this.bytes[this.off++] = (byte)(0x80 | uc >> 12 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | uc >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | uc & 0x3F);
                continue;
            }
            this.bytes[this.off++] = (byte)(0xE0 | c >> 12);
            this.bytes[this.off++] = (byte)(0x80 | c >> 6 & 0x3F);
            this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
        }
    }
}

