/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.Dish;
import com.shiguangjianke.smartfoodsystem.entity.Order;
import com.shiguangjianke.smartfoodsystem.entity.Store;
import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.mapper.OrderMapper;
import com.shiguangjianke.smartfoodsystem.service.DishService;
import com.shiguangjianke.smartfoodsystem.service.OrderService;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
extends ServiceImpl<OrderMapper, Order>
implements OrderService {
    @Autowired
    private StoreService storeService;
    @Autowired
    private DishService dishService;
    @Autowired
    private UserService userService;

    public List<Order> getOrdersByMerchantId(Long merchantId) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores == null || stores.isEmpty()) {
            return new ArrayList<Order>();
        }
        List storeIds = stores.stream().map(Store::getId).collect(Collectors.toList());
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.in((Object)"store_id", storeIds);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        if (dishes == null || dishes.isEmpty()) {
            return new ArrayList<Order>();
        }
        List dishIds = dishes.stream().map(Dish::getId).collect(Collectors.toList());
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"dish_id", dishIds);
        orderQueryWrapper.orderByDesc((Object)"create_time");
        List orders = this.list((Wrapper)orderQueryWrapper);
        this.addDishNameToOrders(orders);
        return orders;
    }

    public IPage<Order> getOrdersByMerchantId(Long merchantId, Integer page, Integer pageSize) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores == null || stores.isEmpty()) {
            return new Page((long)page.intValue(), (long)pageSize.intValue());
        }
        List storeIds = stores.stream().map(Store::getId).collect(Collectors.toList());
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.in((Object)"store_id", storeIds);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        if (dishes == null || dishes.isEmpty()) {
            return new Page((long)page.intValue(), (long)pageSize.intValue());
        }
        List dishIds = dishes.stream().map(Dish::getId).collect(Collectors.toList());
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"dish_id", dishIds);
        orderQueryWrapper.orderByDesc((Object)"create_time");
        Page orderPage = new Page((long)page.intValue(), (long)pageSize.intValue());
        IPage resultPage = this.page((IPage)orderPage, (Wrapper)orderQueryWrapper);
        this.addDishNameToOrders(resultPage.getRecords());
        return resultPage;
    }

    private void addDishNameToOrders(List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return;
        }
        List dishIds = orders.stream().map(Order::getDishId).distinct().collect(Collectors.toList());
        List dishes = this.dishService.listByIds(dishIds);
        Map<Long, String> dishNameMap = dishes.stream().collect(Collectors.toMap(Dish::getId, Dish::getName));
        List userIds = orders.stream().map(Order::getUserId).distinct().collect(Collectors.toList());
        List users = this.userService.listByIds(userIds);
        Map<Long, User> userMap = users.stream().collect(Collectors.toMap(User::getId, user -> user));
        for (Order order : orders) {
            order.setDishName(dishNameMap.getOrDefault(order.getDishId(), "\u672a\u77e5\u83dc\u54c1"));
            User user2 = userMap.get(order.getUserId());
            if (user2 == null) continue;
            order.setUsername(user2.getUsername());
            order.setPhone(user2.getPhone());
        }
    }

    public boolean updateOrderStatus(Long orderId, String status) {
        Order order = (Order)this.getById((Serializable)orderId);
        if (order == null) {
            return false;
        }
        order.setStatus(status);
        order.setUpdateTime(new Date());
        return this.updateById((Object)order);
    }

    public IPage<Order> getOrdersByUserId(Long userId, Integer page, Integer pageSize) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"user_id", (Object)userId);
        orderQueryWrapper.orderByDesc((Object)"create_time");
        Page orderPage = new Page((long)page.intValue(), (long)pageSize.intValue());
        IPage resultPage = this.page((IPage)orderPage, (Wrapper)orderQueryWrapper);
        this.addDishNameToOrders(resultPage.getRecords());
        return resultPage;
    }
}

