/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shiguangjianke.smartfoodsystem.entity.Evaluation;
import com.shiguangjianke.smartfoodsystem.mapper.EvaluationMapper;
import com.shiguangjianke.smartfoodsystem.service.EvaluationService;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class EvaluationServiceImpl
extends ServiceImpl<EvaluationMapper, Evaluation>
implements EvaluationService {
    public List<Evaluation> getByStoreId(Long storeId) {
        return this.list((Wrapper)new QueryWrapper().eq((Object)"store_id", (Object)storeId));
    }

    public List<Evaluation> getByUserId(Long userId) {
        return this.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
    }

    public IPage<Evaluation> getByUserId(Long userId, int page, int pageSize) {
        Page evaluationPage = new Page((long)page, (long)pageSize);
        return this.page((IPage)evaluationPage, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).orderByDesc((Object)"create_time"));
    }

    public Double calculateAverageScore(Long storeId) {
        List evaluations = this.getByStoreId(storeId);
        if (evaluations == null || evaluations.isEmpty()) {
            return 0.0;
        }
        double totalScore = 0.0;
        for (Evaluation evaluation : evaluations) {
            totalScore += (double)(evaluation.getTasteScore() + evaluation.getEnvironmentScore() + evaluation.getServiceScore() + evaluation.getHygieneScore());
        }
        return totalScore / (double)(evaluations.size() * 4);
    }

    public Integer getEvaluationCount(Long storeId) {
        return Math.toIntExact(this.count((Wrapper)new QueryWrapper().eq((Object)"store_id", (Object)storeId)));
    }

    public IPage<Evaluation> getByStoreId(Long storeId, int page, int pageSize) {
        Page evaluationPage = new Page((long)page, (long)pageSize);
        return this.page((IPage)evaluationPage, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"store_id", (Object)storeId)).orderByDesc((Object)"create_time"));
    }

    public boolean updateReply(Evaluation evaluation) {
        evaluation.setReplyTime(new Date());
        return this.updateById((Object)evaluation);
    }
}

