/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
public class UserController
extends BaseController {
    @Autowired
    private UserService userService;

    @GetMapping(value={"/merchant/list"})
    public Result getMerchantList(@RequestParam(required=false) String keyword, @RequestParam(required=false) Integer merchantApplyStatus, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_type", (Object)2);
        if (keyword != null && !keyword.isEmpty()) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"username", (Object)keyword)).or()).like((Object)"phone", (Object)keyword);
        }
        if (merchantApplyStatus != null) {
            queryWrapper.eq((Object)"merchant_apply_status", (Object)merchantApplyStatus);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page userPage = new Page((long)page.intValue(), (long)pageSize.intValue());
        IPage result = this.userService.page((IPage)userPage, (Wrapper)queryWrapper);
        return this.success((Object)result);
    }

    @GetMapping(value={"/merchant/detail/{id}"})
    public Result getMerchantDetail(@PathVariable Long id) {
        User user = (User)this.userService.getById((Serializable)id);
        if (user == null || user.getUserType() != 2) {
            return this.error(404, "\u5546\u5bb6\u4e0d\u5b58\u5728");
        }
        return this.success((Object)user);
    }

    @PutMapping(value={"/merchant/apply/status"})
    public Result updateMerchantApplyStatus(@RequestParam Long id, @RequestParam Integer status) {
        boolean result = this.userService.updateMerchantApplyStatus(id, status);
        if (result) {
            return this.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return this.error("\u66f4\u65b0\u5931\u8d25");
    }

    @DeleteMapping(value={"/merchant/{id}"})
    public Result deleteMerchant(@PathVariable Long id) {
        User user = (User)this.userService.getById((Serializable)id);
        if (user == null || user.getUserType() != 2) {
            return this.error(404, "\u5546\u5bb6\u4e0d\u5b58\u5728");
        }
        boolean result = this.userService.removeById((Serializable)id);
        if (result) {
            return this.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return this.error("\u5220\u9664\u5931\u8d25");
    }

    @PutMapping(value={"/merchant/update"})
    public Result updateMerchant(@RequestBody User user) {
        user.setUserType(Integer.valueOf(2));
        boolean result = this.userService.updateById((Object)user);
        if (result) {
            return this.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return this.error("\u66f4\u65b0\u5931\u8d25");
    }
}

