/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class UploadController
extends BaseController {
    @Value(value="${upload.path:./upload}")
    private String uploadPath;
    @Value(value="${upload.url-prefix:http://localhost:8080/upload}")
    private String uploadUrlPrefix;

    @PostMapping(value={"/upload"})
    public Result uploadFile(@RequestParam(value="file") MultipartFile file) {
        if (file.isEmpty()) {
            return this.error(400, "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            File uploadDir = new File(this.uploadPath);
            if (!uploadDir.exists()) {
                uploadDir.mkdirs();
            }
            String originalFilename = file.getOriginalFilename();
            String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
            String fileName = UUID.randomUUID().toString() + suffix;
            String datePath = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
            File dateDir = new File(uploadDir, datePath);
            if (!dateDir.exists()) {
                dateDir.mkdirs();
            }
            File destFile = new File(dateDir, fileName);
            file.transferTo(destFile);
            String fileUrl = this.uploadUrlPrefix + "/" + datePath + "/" + fileName;
            return this.success((Object)fileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.error(500, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

