/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Store;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/store"})
public class StoreController
extends BaseController {
    @Autowired
    private StoreService storeService;

    @GetMapping(value={"/recommend"})
    public Result recommendStores() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)1)).orderByDesc((Object)"average_score")).last("LIMIT 6");
        return this.success((Object)this.storeService.list((Wrapper)queryWrapper));
    }

    @GetMapping(value={"/list"})
    public Result getStoreList(@RequestParam(required=false) String keyword, @RequestParam(required=false) Integer status, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)1);
        if (keyword != null && !keyword.isEmpty()) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"name", (Object)keyword)).or()).like((Object)"description", (Object)keyword);
        }
        queryWrapper.orderByDesc((Object)"average_score");
        Page storePage = new Page((long)page.intValue(), (long)pageSize.intValue());
        IPage result = this.storeService.page((IPage)storePage, (Wrapper)queryWrapper);
        return this.success((Object)result);
    }

    @GetMapping(value={"/detail/{id}"})
    public Result getStoreDetail(@PathVariable Long id) {
        Store store = (Store)this.storeService.getById((Serializable)id);
        if (store == null) {
            return this.error(404, "\u5e97\u9762\u4e0d\u5b58\u5728");
        }
        return this.success((Object)store);
    }

    @GetMapping(value={"/list/merchant/{merchantId}"})
    public Result getStoreListByMerchantId(@PathVariable Long merchantId) {
        List stores = this.storeService.getByMerchantId(merchantId);
        return this.success((Object)stores);
    }

    @PostMapping(value={"/add"})
    public Result addStore(@RequestBody Store store) {
        store.setStatus(Integer.valueOf(0));
        this.storeService.save((Object)store);
        return this.success((Object)"\u6dfb\u52a0\u6210\u529f\uff0c\u7b49\u5f85\u5ba1\u6838");
    }

    @PutMapping(value={"/update"})
    public Result updateStore(@RequestBody Store store) {
        this.storeService.updateById((Object)store);
        return this.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{id}"})
    public Result deleteStore(@PathVariable Long id) {
        this.storeService.removeById((Serializable)id);
        return this.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/list/status/{status}"})
    public Result getStoreListByStatus(@PathVariable Integer status) {
        List stores = this.storeService.getByStatus(status);
        return this.success((Object)stores);
    }

    @PutMapping(value={"/audit/{id}"})
    public Result auditStore(@PathVariable Long id, @RequestParam Integer status) {
        Store store = (Store)this.storeService.getById((Serializable)id);
        if (store == null) {
            return this.error(404, "\u5e97\u9762\u4e0d\u5b58\u5728");
        }
        if (status == 1) {
            store.setStatus(Integer.valueOf(1));
        } else if (status == 3) {
            store.setStatus(Integer.valueOf(4));
        } else {
            return this.error(400, "\u65e0\u6548\u7684\u5ba1\u6838\u72b6\u6001");
        }
        this.storeService.updateById((Object)store);
        return this.success((Object)"\u5ba1\u6838\u6210\u529f");
    }

    @PutMapping(value={"/status/{id}"})
    public Result updateStoreStatus(@PathVariable Long id, @RequestParam Integer status) {
        Store store = (Store)this.storeService.getById((Serializable)id);
        if (store == null) {
            return this.error(404, "\u5e97\u9762\u4e0d\u5b58\u5728");
        }
        if (store.getStatus() == 0 || store.getStatus() == 4) {
            return this.error(400, "\u8be5\u5e97\u94fa\u672a\u901a\u8fc7\u5ba1\u6838\uff0c\u65e0\u6cd5\u4fee\u6539\u8425\u4e1a\u72b6\u6001");
        }
        if (status != 1 && status != 2 && status != 3) {
            return this.error(400, "\u65e0\u6548\u7684\u8425\u4e1a\u72b6\u6001");
        }
        store.setStatus(status);
        this.storeService.updateById((Object)store);
        return this.success((Object)"\u8425\u4e1a\u72b6\u6001\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/admin/list"})
    public Result getAdminStoreList(@RequestParam(required=false) String keyword, @RequestParam(required=false) Integer status, @RequestParam(required=false) Long merchantId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (keyword != null && !keyword.isEmpty()) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"name", (Object)keyword)).or()).like((Object)"description", (Object)keyword);
        }
        if (status != null) {
            queryWrapper.eq((Object)"status", (Object)status);
        }
        if (merchantId != null) {
            queryWrapper.eq((Object)"merchant_id", (Object)merchantId);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page storePage = new Page((long)page.intValue(), (long)pageSize.intValue());
        IPage result = this.storeService.page((IPage)storePage, (Wrapper)queryWrapper);
        return this.success((Object)result);
    }
}

