/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Order;
import com.shiguangjianke.smartfoodsystem.service.OrderService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/order"})
public class OrderController
extends BaseController {
    @Autowired
    private OrderService orderService;

    @PostMapping(value={"/add"})
    public Result addOrder(@RequestBody Order order) {
        order.setStatus("pending");
        Date now = new Date();
        order.setCreateTime(now);
        order.setUpdateTime(now);
        boolean result = this.orderService.save((Object)order);
        if (result) {
            return this.success((Object)"\u8ba2\u5355\u521b\u5efa\u6210\u529f");
        }
        return this.error(500, "\u8ba2\u5355\u521b\u5efa\u5931\u8d25");
    }

    @GetMapping(value={"/merchant/messages"})
    public Result getMerchantOrderMessages(@RequestParam Long merchantId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        return this.success((Object)this.orderService.getOrdersByMerchantId(merchantId, page, pageSize));
    }

    @GetMapping(value={"/merchant/all"})
    public Result getMerchantAllOrders(@RequestParam Long merchantId) {
        return this.success((Object)this.orderService.getOrdersByMerchantId(merchantId));
    }

    @PutMapping(value={"/update/status"})
    public Result updateOrderStatus(@RequestParam Long orderId, @RequestParam String status) {
        boolean result = this.orderService.updateOrderStatus(orderId, status);
        if (result) {
            return this.success((Object)"\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        return this.error(500, "\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
    }

    @GetMapping(value={"/user/list"})
    public Result getUserOrderList(@RequestParam Long userId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        return this.success((Object)this.orderService.getOrdersByUserId(userId, page, pageSize));
    }
}

