/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Feedback;
import com.shiguangjianke.smartfoodsystem.service.FeedbackService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/feedback"})
public class FeedbackController
extends BaseController {
    @Autowired
    private FeedbackService feedbackService;

    @GetMapping(value={"/list"})
    public Result getFeedbackList() {
        List feedbacks = this.feedbackService.list();
        return this.success((Object)feedbacks);
    }

    @GetMapping(value={"/admin/list"})
    public Result getAdminFeedbackList(@RequestParam(required=false) String keyword, @RequestParam(required=false) Integer status, @RequestParam(required=false) Integer type, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (keyword != null && !keyword.isEmpty()) {
            queryWrapper.like((Object)"content", (Object)keyword);
        }
        if (status != null) {
            queryWrapper.eq((Object)"status", (Object)status);
        }
        if (type != null) {
            queryWrapper.eq((Object)"type", (Object)type);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page feedbackPage = new Page((long)page.intValue(), (long)pageSize.intValue());
        IPage result = this.feedbackService.page((IPage)feedbackPage, (Wrapper)queryWrapper);
        return this.success((Object)result);
    }

    @GetMapping(value={"/list/user/{userId}"})
    public Result getFeedbackListByUserId(@PathVariable Long userId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        IPage feedbackPage = this.feedbackService.getByUserId(userId, page.intValue(), pageSize.intValue());
        return this.success((Object)feedbackPage);
    }

    @GetMapping(value={"/list/status/{status}"})
    public Result getFeedbackListByStatus(@PathVariable Integer status) {
        List feedbacks = this.feedbackService.getByStatus(status);
        return this.success((Object)feedbacks);
    }

    @PostMapping(value={"/add"})
    public Result addFeedback(@RequestBody Feedback feedback) {
        feedback.setStatus(Integer.valueOf(0));
        this.feedbackService.save((Object)feedback);
        return this.success((Object)"\u53cd\u9988\u6210\u529f");
    }

    @PutMapping(value={"/update/status/{id}"})
    public Result updateFeedbackStatus(@PathVariable Long id, @RequestParam Integer status) {
        this.feedbackService.updateStatus(id, status);
        return this.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/admin/handle/{id}"})
    public Result handleFeedback(@PathVariable Long id, @RequestBody Feedback feedback) {
        try {
            System.out.println("\u5904\u7406\u53cd\u9988\u8bf7\u6c42\uff0cID: " + id);
            System.out.println("\u63a5\u6536\u5230\u7684\u53cd\u9988\u4fe1\u606f: " + feedback);
            Feedback existingFeedback = new Feedback();
            existingFeedback.setId(id);
            existingFeedback.setStatus(feedback.getStatus());
            existingFeedback.setHandleResult(feedback.getHandleResult());
            existingFeedback.setHandleAdminId(null);
            existingFeedback.setHandleTime(new Date());
            System.out.println("\u51c6\u5907\u66f4\u65b0\u7684\u53cd\u9988\u4fe1\u606f: " + existingFeedback);
            boolean result = this.feedbackService.updateById((Object)existingFeedback);
            System.out.println("\u66f4\u65b0\u7ed3\u679c: " + result);
            return this.success((Object)"\u53cd\u9988\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            System.out.println("\u5904\u7406\u53cd\u9988\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f: " + e.getMessage());
            e.printStackTrace();
            return this.error("\u5904\u7406\u53cd\u9988\u5931\u8d25");
        }
    }
}

