/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Favorite;
import com.shiguangjianke.smartfoodsystem.service.FavoriteService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/favorite"})
public class FavoriteController
extends BaseController {
    @Autowired
    private FavoriteService favoriteService;

    @GetMapping(value={"/list/{userId}"})
    public Result getFavoriteList(@PathVariable Long userId) {
        return this.success((Object)this.favoriteService.getFavoriteStores(userId));
    }

    @PostMapping(value={"/add"})
    public Result addFavorite(@RequestBody Favorite favorite) {
        boolean isFavorite = this.favoriteService.isFavorite(favorite.getUserId(), favorite.getStoreId());
        if (isFavorite) {
            return this.error(400, "\u5df2\u7ecf\u6536\u85cf\u8fc7\u8be5\u5e97\u9762");
        }
        this.favoriteService.save((Object)favorite);
        return this.success((Object)"\u6536\u85cf\u6210\u529f");
    }

    @DeleteMapping(value={"/cancel/{userId}/{storeId}"})
    public Result cancelFavorite(@PathVariable Long userId, @PathVariable Long storeId) {
        Favorite favorite = this.favoriteService.getByUserIdAndStoreId(userId, storeId);
        if (favorite == null) {
            return this.error(404, "\u672a\u6536\u85cf\u8be5\u5e97\u9762");
        }
        this.favoriteService.removeById((Serializable)favorite.getId());
        return this.success((Object)"\u53d6\u6d88\u6536\u85cf\u6210\u529f");
    }

    @GetMapping(value={"/check/{userId}/{storeId}"})
    public Result checkFavorite(@PathVariable Long userId, @PathVariable Long storeId) {
        boolean isFavorite = this.favoriteService.isFavorite(userId, storeId);
        return this.success((Object)isFavorite);
    }
}

