/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Evaluation;
import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.service.EvaluationService;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/evaluation"})
public class EvaluationController
extends BaseController {
    @Autowired
    private EvaluationService evaluationService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private UserService userService;

    @GetMapping(value={"/list/{storeId}"})
    public Result getEvaluationListByStoreId(@PathVariable Long storeId) {
        List evaluations = this.evaluationService.getByStoreId(storeId);
        return this.success((Object)evaluations);
    }

    @GetMapping(value={"/list/user/{userId}"})
    public Result getEvaluationListByUserId(@PathVariable Long userId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer pageSize) {
        IPage evaluationPage = this.evaluationService.getByUserId(userId, page.intValue(), pageSize.intValue());
        return this.success((Object)evaluationPage);
    }

    @PostMapping(value={"/add"})
    public Result addEvaluation(@RequestBody Evaluation evaluation) {
        System.out.println("\u63a5\u6536\u5230\u7684\u8bc4\u4ef7\u6570\u636e: " + evaluation);
        System.out.println("\u7528\u6237ID: " + evaluation.getUserId());
        Long userId = evaluation.getUserId();
        System.out.println("\u83b7\u53d6\u5230\u7684\u7528\u6237ID: " + userId);
        if (userId == null) {
            System.out.println("\u7528\u6237ID\u4e3a\u7a7a\uff0c\u8fd4\u56de400\u9519\u8bef");
            return this.error(400, "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = (User)this.userService.getById((Serializable)userId);
        System.out.println("\u67e5\u8be2\u7528\u6237\u7ed3\u679c: " + user);
        if (user == null) {
            System.out.println("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de404\u9519\u8bef");
            return this.error(404, "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        this.evaluationService.save((Object)evaluation);
        Long storeId = evaluation.getStoreId();
        Double averageScore = this.evaluationService.calculateAverageScore(storeId);
        Integer evaluationCount = this.evaluationService.getEvaluationCount(storeId);
        this.storeService.updateAverageScore(storeId, averageScore);
        this.storeService.updateEvaluationCount(storeId, evaluationCount);
        return this.success((Object)"\u8bc4\u4ef7\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{id}"})
    public Result deleteEvaluation(@PathVariable Long id) {
        Evaluation evaluation = (Evaluation)this.evaluationService.getById((Serializable)id);
        if (evaluation == null) {
            return this.error(404, "\u8bc4\u4ef7\u4e0d\u5b58\u5728");
        }
        this.evaluationService.removeById((Serializable)id);
        Long storeId = evaluation.getStoreId();
        Double averageScore = this.evaluationService.calculateAverageScore(storeId);
        Integer evaluationCount = this.evaluationService.getEvaluationCount(storeId);
        this.storeService.updateAverageScore(storeId, averageScore);
        this.storeService.updateEvaluationCount(storeId, evaluationCount);
        return this.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/list/store/{storeId}"})
    public Result getEvaluationListByStoreId(@PathVariable Long storeId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize) {
        IPage evaluationPage = this.evaluationService.getByStoreId(storeId, page, pageSize);
        return this.success((Object)evaluationPage);
    }

    @PutMapping(value={"/reply/update"})
    public Result updateEvaluationReply(@RequestBody Evaluation evaluation) {
        boolean result = this.evaluationService.updateReply(evaluation);
        if (result) {
            return this.success((Object)"\u56de\u590d\u66f4\u65b0\u6210\u529f");
        }
        return this.error(500, "\u56de\u590d\u66f4\u65b0\u5931\u8d25");
    }
}

