/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Dish;
import com.shiguangjianke.smartfoodsystem.service.DishService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dish"})
public class DishController
extends BaseController {
    @Autowired
    private DishService dishService;

    @GetMapping(value={"/list/{storeId}"})
    public Result getDishListByStoreId(@PathVariable Long storeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"store_id", (Object)storeId);
        List dishes = this.dishService.list((Wrapper)queryWrapper);
        return this.success((Object)dishes);
    }

    @GetMapping(value={"/detail/{id}"})
    public Result getDishDetail(@PathVariable Long id) {
        Dish dish = (Dish)this.dishService.getById((Serializable)id);
        if (dish == null) {
            return this.error(404, "\u83dc\u54c1\u4e0d\u5b58\u5728");
        }
        return this.success((Object)dish);
    }

    @PostMapping(value={"/add"})
    public Result addDish(@RequestBody Dish dish) {
        this.dishService.save((Object)dish);
        return this.success((Object)"\u6dfb\u52a0\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public Result updateDish(@RequestBody Dish dish) {
        this.dishService.updateById((Object)dish);
        return this.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{id}"})
    public Result deleteDish(@PathVariable Long id) {
        this.dishService.removeById((Serializable)id);
        return this.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/update/status/{id}"})
    public Result updateDishStatus(@PathVariable Long id, @RequestBody Map<String, String> requestBody) {
        if (requestBody == null || !requestBody.containsKey("status")) {
            return this.error(400, "\u53c2\u6570\u9519\u8bef");
        }
        String status = requestBody.get("status");
        if (!"on_sale".equals(status) && !"off_sale".equals(status)) {
            return this.error(400, "\u72b6\u6001\u503c\u65e0\u6548");
        }
        Dish dish = (Dish)this.dishService.getById((Serializable)id);
        if (dish == null) {
            return this.error(404, "\u83dc\u54c1\u4e0d\u5b58\u5728");
        }
        dish.setStatus(status);
        this.dishService.updateById((Object)dish);
        return this.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
    }
}

