/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Dish;
import com.shiguangjianke.smartfoodsystem.entity.Order;
import com.shiguangjianke.smartfoodsystem.entity.Store;
import com.shiguangjianke.smartfoodsystem.service.DishService;
import com.shiguangjianke.smartfoodsystem.service.OrderService;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/data-statistics"})
public class DataStatisticsController
extends BaseController {
    @Autowired
    private OrderService orderService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private DishService dishService;

    @GetMapping(value={"/basic"})
    public Result getBasicStatistics(@RequestParam Long merchantId) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores.isEmpty()) {
            return this.success((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        List<Long> storeIds = stores.stream().map(Store::getId).toList();
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.in((Object)"store_id", storeIds);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        if (dishes.isEmpty()) {
            return this.success((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        List<Long> dishIds = dishes.stream().map(Dish::getId).toList();
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"dish_id", dishIds);
        List orders = this.orderService.list((Wrapper)orderQueryWrapper);
        int totalOrders = orders.size();
        BigDecimal totalRevenue = orders.stream().map(Order::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal averageOrderPrice = totalOrders > 0 ? totalRevenue.divide(new BigDecimal(totalOrders), 2, 4) : new BigDecimal(0);
        int customerCount = (int)orders.stream().map(Order::getUserId).distinct().count();
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("totalOrders", totalOrders);
        result.put("totalRevenue", totalRevenue);
        result.put("averageOrderPrice", averageOrderPrice);
        result.put("customerCount", customerCount);
        return this.success(result);
    }

    @GetMapping(value={"/order/trend"})
    public Result getOrderTrend(@RequestParam Long merchantId, @RequestParam(defaultValue="week") String timeRange) {
        ArrayList dates = new ArrayList();
        ArrayList<Integer> orderCounts = new ArrayList<Integer>();
        Calendar calendar = Calendar.getInstance();
        Date endDate = calendar.getTime();
        Date startDate = null;
        if ("week".equals(timeRange)) {
            calendar.add(5, -6);
            startDate = calendar.getTime();
        } else if ("month".equals(timeRange)) {
            calendar.add(5, -29);
            startDate = calendar.getTime();
        } else if ("quarter".equals(timeRange)) {
            calendar.add(5, -89);
            startDate = calendar.getTime();
        } else if ("year".equals(timeRange)) {
            calendar.add(2, -11);
            startDate = calendar.getTime();
        }
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.eq((Object)"merchant_id", (Object)merchantId);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        if (dishes.isEmpty()) {
            HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
            result.put("dates", dates);
            result.put("orderCounts", orderCounts);
            return this.success(result);
        }
        List dishIds = dishes.stream().map(Dish::getId).collect(Collectors.toList());
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"dish_id", dishIds);
        orderQueryWrapper.between((Object)"create_time", (Object)startDate, (Object)endDate);
        List orders = this.orderService.list((Wrapper)orderQueryWrapper);
        LinkedHashMap<Object, Integer> orderCountMap = new LinkedHashMap<Object, Integer>();
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTime(startDate);
        SimpleDateFormat dateFormat = null;
        dateFormat = "year".equals(timeRange) ? new SimpleDateFormat("yyyy-MM") : new SimpleDateFormat("MM-dd");
        while (!tempCalendar.getTime().after(endDate)) {
            Iterator dateStr = dateFormat.format(tempCalendar.getTime());
            dates.add(dateStr);
            orderCountMap.put(dateStr, 0);
            if ("year".equals(timeRange)) {
                tempCalendar.add(2, 1);
                continue;
            }
            tempCalendar.add(5, 1);
        }
        for (Order order : orders) {
            String dateStr = dateFormat.format(order.getCreateTime());
            orderCountMap.put(dateStr, orderCountMap.getOrDefault(dateStr, 0) + 1);
        }
        for (String string : dates) {
            orderCounts.add(orderCountMap.getOrDefault(string, 0));
        }
        HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
        result.put("dates", dates);
        result.put("orderCounts", orderCounts);
        return this.success(result);
    }

    @GetMapping(value={"/revenue/trend"})
    public Result getRevenueTrend(@RequestParam Long merchantId, @RequestParam(defaultValue="week") String timeRange) {
        ArrayList dates = new ArrayList();
        ArrayList<BigDecimal> revenues = new ArrayList<BigDecimal>();
        Calendar calendar = Calendar.getInstance();
        Date endDate = calendar.getTime();
        Date startDate = null;
        if ("week".equals(timeRange)) {
            calendar.add(5, -6);
            startDate = calendar.getTime();
        } else if ("month".equals(timeRange)) {
            calendar.add(5, -29);
            startDate = calendar.getTime();
        } else if ("quarter".equals(timeRange)) {
            calendar.add(5, -89);
            startDate = calendar.getTime();
        } else if ("year".equals(timeRange)) {
            calendar.add(2, -11);
            startDate = calendar.getTime();
        }
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.eq((Object)"merchant_id", (Object)merchantId);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        if (dishes.isEmpty()) {
            HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
            result.put("dates", dates);
            result.put("revenues", revenues);
            return this.success(result);
        }
        List dishIds = dishes.stream().map(Dish::getId).collect(Collectors.toList());
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"dish_id", dishIds);
        orderQueryWrapper.between((Object)"create_time", (Object)startDate, (Object)endDate);
        List orders = this.orderService.list((Wrapper)orderQueryWrapper);
        LinkedHashMap<Object, BigDecimal> revenueMap = new LinkedHashMap<Object, BigDecimal>();
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTime(startDate);
        SimpleDateFormat dateFormat = null;
        dateFormat = "year".equals(timeRange) ? new SimpleDateFormat("yyyy-MM") : new SimpleDateFormat("MM-dd");
        while (!tempCalendar.getTime().after(endDate)) {
            Iterator dateStr = dateFormat.format(tempCalendar.getTime());
            dates.add(dateStr);
            revenueMap.put(dateStr, BigDecimal.ZERO);
            if ("year".equals(timeRange)) {
                tempCalendar.add(2, 1);
                continue;
            }
            tempCalendar.add(5, 1);
        }
        for (Order order : orders) {
            String dateStr = dateFormat.format(order.getCreateTime());
            BigDecimal orderAmount = order.getTotalPrice() != null ? order.getTotalPrice() : BigDecimal.ZERO;
            revenueMap.put(dateStr, ((BigDecimal)revenueMap.get(dateStr)).add(orderAmount));
        }
        for (String string : dates) {
            revenues.add(((BigDecimal)revenueMap.get(string)).setScale(2, 4));
        }
        HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
        result.put("dates", dates);
        result.put("revenues", revenues);
        return this.success(result);
    }

    @GetMapping(value={"/dish/sales/ranking"})
    public Result getDishSalesRanking(@RequestParam Long merchantId, @RequestParam(defaultValue="10") Integer limit) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores.isEmpty()) {
            return this.success((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        List<Long> storeIds = stores.stream().map(Store::getId).toList();
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)dishQueryWrapper.in((Object)"store_id", storeIds)).orderByDesc((Object)"create_time")).last("LIMIT " + limit);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        List<String> dishNames = dishes.stream().map(Dish::getName).toList();
        ArrayList<Integer> sales = new ArrayList<Integer>();
        Random random = new Random();
        for (int i = 0; i < dishes.size(); ++i) {
            sales.add(random.nextInt(100) + 10);
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        result.put("dishNames", dishNames);
        result.put("sales", sales);
        return this.success(result);
    }

    @GetMapping(value={"/customer/distribution"})
    public Result getCustomerDistribution(@RequestParam Long merchantId) {
        List<String> regions = Arrays.asList("\u671d\u9633\u533a", "\u6d77\u6dc0\u533a", "\u4e1c\u57ce\u533a", "\u897f\u57ce\u533a", "\u4e30\u53f0\u533a", "\u77f3\u666f\u5c71\u533a", "\u901a\u5dde\u533a", "\u5927\u5174\u533a");
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (int i = 0; i < regions.size(); ++i) {
            counts.add(new Random().nextInt(500) + 100);
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        result.put("regions", regions);
        result.put("counts", counts);
        return this.success(result);
    }

    @GetMapping(value={"/order/detail"})
    public Result getOrderDetail(@RequestParam Long merchantId, @RequestParam String timeRange) {
        ArrayList orderData = new ArrayList();
        Calendar calendar = Calendar.getInstance();
        int days = 30;
        if ("7days".equals(timeRange)) {
            days = 7;
        } else if ("90days".equals(timeRange)) {
            days = 90;
        } else if ("180days".equals(timeRange)) {
            days = 180;
        } else if ("365days".equals(timeRange)) {
            days = 365;
        }
        for (int i = days - 1; i >= 0; --i) {
            calendar.add(5, -1);
            Date date = calendar.getTime();
            String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
            HashMap<String, Object> order = new HashMap<String, Object>();
            order.put("date", dateStr);
            order.put("orders", new Random().nextInt(50) + 20);
            order.put("revenue", new BigDecimal(new Random().nextInt(5000) + 2000).setScale(2, 4));
            order.put("avgOrderValue", new BigDecimal(new Random().nextInt(200) + 50).setScale(2, 4));
            orderData.add(order);
        }
        return this.success(orderData);
    }

    @GetMapping(value={"/dish/detail"})
    public Result getDishDetail(@RequestParam Long merchantId, @RequestParam String timeRange) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores.isEmpty()) {
            return this.success(new ArrayList());
        }
        List<Long> storeIds = stores.stream().map(Store::getId).toList();
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.in((Object)"store_id", storeIds);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        ArrayList dishData = new ArrayList();
        Random random = new Random();
        for (Dish dish : dishes) {
            HashMap<String, Object> dishMap = new HashMap<String, Object>();
            dishMap.put("dishName", dish.getName());
            int sales = random.nextInt(100) + 10;
            dishMap.put("sales", sales);
            BigDecimal price = dish.getPrice() != null ? dish.getPrice() : BigDecimal.ZERO;
            dishMap.put("revenue", price.multiply(new BigDecimal(sales)));
            dishMap.put("rating", new BigDecimal(random.nextDouble() * 2.0 + 3.0).setScale(1, 4));
            dishData.add(dishMap);
        }
        return this.success(dishData);
    }

    @GetMapping(value={"/store/detail"})
    public Result getStoreDetail(@RequestParam Long merchantId, @RequestParam String timeRange) {
        List stores = this.storeService.getByMerchantId(merchantId);
        ArrayList storeData = new ArrayList();
        for (Store store : stores) {
            HashMap<String, Object> storeMap = new HashMap<String, Object>();
            storeMap.put("storeName", store.getName());
            storeMap.put("orders", new Random().nextInt(500) + 200);
            storeMap.put("revenue", new BigDecimal(new Random().nextInt(50000) + 20000).setScale(2, 4));
            storeMap.put("customers", new Random().nextInt(300) + 100);
            storeData.add(storeMap);
        }
        return this.success(storeData);
    }
}

