/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.entity.Dish;
import com.shiguangjianke.smartfoodsystem.entity.Evaluation;
import com.shiguangjianke.smartfoodsystem.entity.Store;
import com.shiguangjianke.smartfoodsystem.service.DishService;
import com.shiguangjianke.smartfoodsystem.service.EvaluationService;
import com.shiguangjianke.smartfoodsystem.service.OrderService;
import com.shiguangjianke.smartfoodsystem.service.StoreService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dashboard"})
public class DashboardController
extends BaseController {
    @Autowired
    private OrderService orderService;
    @Autowired
    private EvaluationService evaluationService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private DishService dishService;

    @GetMapping(value={"/stats"})
    public Result getDashboardStats(@RequestParam Long merchantId) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores.isEmpty()) {
            return this.success((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        List<Long> storeIds = stores.stream().map(Store::getId).toList();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date todayStart = calendar.getTime();
        QueryWrapper dishQueryWrapper = new QueryWrapper();
        dishQueryWrapper.in((Object)"store_id", storeIds);
        List dishes = this.dishService.list((Wrapper)dishQueryWrapper);
        int todayOrders = 0;
        if (!dishes.isEmpty()) {
            List<Long> dishIds = dishes.stream().map(Dish::getId).toList();
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            ((QueryWrapper)orderQueryWrapper.in((Object)"dish_id", dishIds)).ge((Object)"create_time", (Object)todayStart);
            todayOrders = (int)this.orderService.count((Wrapper)orderQueryWrapper);
        }
        QueryWrapper evalQueryWrapper = new QueryWrapper();
        ((QueryWrapper)evalQueryWrapper.in((Object)"store_id", storeIds)).ge((Object)"create_time", (Object)todayStart);
        int todayEvaluations = (int)this.evaluationService.count((Wrapper)evalQueryWrapper);
        double averageScore = stores.stream().mapToDouble(store -> store.getAverageScore().doubleValue()).average().orElse(0.0);
        int openStores = (int)stores.stream().filter(store -> store.getStatus() == 1).count();
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("todayOrders", todayOrders);
        result.put("todayEvaluations", todayEvaluations);
        result.put("averageScore", (double)Math.round(averageScore * 10.0) / 10.0);
        result.put("storeStatus", openStores);
        return this.success(result);
    }

    @GetMapping(value={"/business/trend"})
    public Result getBusinessTrend(@RequestParam Long merchantId, @RequestParam(defaultValue="7") Integer days) {
        ArrayList<String> dates = new ArrayList<String>();
        ArrayList<Integer> orderCounts = new ArrayList<Integer>();
        ArrayList<BigDecimal> revenues = new ArrayList<BigDecimal>();
        try {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
            for (int i = days - 1; i >= 0; --i) {
                Calendar tempCalendar = (Calendar)calendar.clone();
                tempCalendar.add(5, -i);
                String dateStr = sdf.format(tempCalendar.getTime());
                dates.add(dateStr);
                tempCalendar.set(11, 0);
                tempCalendar.set(12, 0);
                tempCalendar.set(13, 0);
                tempCalendar.set(14, 0);
                Date startTime = tempCalendar.getTime();
                tempCalendar.set(11, 23);
                tempCalendar.set(12, 59);
                tempCalendar.set(13, 59);
                tempCalendar.set(14, 999);
                Date endTime = tempCalendar.getTime();
                QueryWrapper orderQueryWrapper = new QueryWrapper();
                orderQueryWrapper.between((Object)"create_time", (Object)startTime, (Object)endTime);
                long orderCount = this.orderService.count((Wrapper)orderQueryWrapper);
                orderCounts.add((int)orderCount);
                List orders = this.orderService.list((Wrapper)orderQueryWrapper);
                BigDecimal revenue = orders.stream().map(order -> order.getTotalPrice() != null ? order.getTotalPrice() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                revenues.add(revenue.setScale(2, 4));
            }
            HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
            result.put("dates", dates);
            result.put("orderCounts", orderCounts);
            result.put("revenues", revenues);
            return this.success(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getMockBusinessTrend(days);
        }
    }

    private Result getMockBusinessTrend(Integer days) {
        ArrayList<String> dates = new ArrayList<String>();
        ArrayList<Integer> orderCounts = new ArrayList<Integer>();
        ArrayList<BigDecimal> revenues = new ArrayList<BigDecimal>();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        Random random = new Random();
        for (int i = days - 1; i >= 0; --i) {
            Calendar tempCalendar = (Calendar)calendar.clone();
            tempCalendar.add(5, -i);
            String dateStr = sdf.format(tempCalendar.getTime());
            dates.add(dateStr);
            int orderCount = random.nextInt(50) + 20;
            BigDecimal revenue = new BigDecimal(orderCount * (random.nextInt(21) + 15)).setScale(2, 4);
            orderCounts.add(orderCount);
            revenues.add(revenue);
        }
        HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
        result.put("dates", dates);
        result.put("orderCounts", orderCounts);
        result.put("revenues", revenues);
        return this.success(result);
    }

    @GetMapping(value={"/evaluation/analysis"})
    public Result getEvaluationAnalysis(@RequestParam Long merchantId) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores.isEmpty()) {
            return this.success((Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        List<Long> storeIds = stores.stream().map(Store::getId).toList();
        Map<Long, String> storeMap = stores.stream().collect(Collectors.toMap(Store::getId, Store::getName));
        ArrayList<Integer> evaluationCounts = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<String> storeNames = new ArrayList<String>();
        ArrayList<Double> tasteScores = new ArrayList<Double>();
        ArrayList<Double> environmentScores = new ArrayList<Double>();
        ArrayList<Double> serviceScores = new ArrayList<Double>();
        ArrayList<Double> hygieneScores = new ArrayList<Double>();
        ArrayList scoreDistribution = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"store_id", storeIds);
        List evaluations = this.evaluationService.list((Wrapper)queryWrapper);
        for (Store store : stores) {
            storeNames.add(store.getName());
            evaluationCounts.add(store.getEvaluationCount());
            scores.add(store.getAverageScore().doubleValue());
            double totalTasteScore = 0.0;
            double totalEnvironmentScore = 0.0;
            double totalServiceScore = 0.0;
            double totalHygieneScore = 0.0;
            int count = 0;
            for (Evaluation eval : evaluations) {
                if (!eval.getStoreId().equals(store.getId())) continue;
                totalTasteScore += (double)eval.getTasteScore().intValue();
                totalEnvironmentScore += (double)eval.getEnvironmentScore().intValue();
                totalServiceScore += (double)eval.getServiceScore().intValue();
                totalHygieneScore += (double)eval.getHygieneScore().intValue();
                ++count;
            }
            tasteScores.add(count > 0 ? totalTasteScore / (double)count : 0.0);
            environmentScores.add(count > 0 ? totalEnvironmentScore / (double)count : 0.0);
            serviceScores.add(count > 0 ? totalServiceScore / (double)count : 0.0);
            hygieneScores.add(count > 0 ? totalHygieneScore / (double)count : 0.0);
        }
        HashMap<Integer, Integer> scoreCountMap = new HashMap<Integer, Integer>();
        for (int i = 1; i <= 5; ++i) {
            scoreCountMap.put(i, 0);
        }
        for (Evaluation eval : evaluations) {
            double totalScore = (double)(eval.getTasteScore() + eval.getEnvironmentScore() + eval.getServiceScore() + eval.getHygieneScore()) / 4.0;
            int roundedScore = (int)Math.round(totalScore);
            scoreCountMap.put(roundedScore, (Integer)scoreCountMap.get(roundedScore) + 1);
        }
        for (int i = 1; i <= 5; ++i) {
            HashMap<String, Integer> scoreItem = new HashMap<String, Integer>();
            scoreItem.put("score", i);
            scoreItem.put("count", (Integer)scoreCountMap.get(i));
            scoreDistribution.add(scoreItem);
        }
        HashMap<String, ArrayList<Object>> result = new HashMap<String, ArrayList<Object>>();
        result.put("evaluationCounts", evaluationCounts);
        result.put("scores", scores);
        result.put("storeNames", storeNames);
        result.put("tasteScores", tasteScores);
        result.put("environmentScores", environmentScores);
        result.put("serviceScores", serviceScores);
        result.put("hygieneScores", hygieneScores);
        result.put("scoreDistribution", scoreDistribution);
        return this.success(result);
    }

    @GetMapping(value={"/evaluations/latest"})
    public Result getLatestEvaluations(@RequestParam Long merchantId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="5") Integer pageSize) {
        List stores = this.storeService.getByMerchantId(merchantId);
        if (stores.isEmpty()) {
            return this.success(new ArrayList());
        }
        List<Long> storeIds = stores.stream().map(Store::getId).toList();
        Page evalPage = new Page((long)page.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.in((Object)"store_id", storeIds)).orderByDesc((Object)"create_time");
        IPage resultPage = this.evaluationService.page((IPage)evalPage, (Wrapper)queryWrapper);
        return this.success((Object)resultPage);
    }
}

