/*
 * Decompiled with CFR 0.152.
 */
package com.shiguangjianke.smartfoodsystem.controller;

import com.shiguangjianke.smartfoodsystem.controller.BaseController;
import com.shiguangjianke.smartfoodsystem.controller.Result;
import com.shiguangjianke.smartfoodsystem.dto.LoginDto;
import com.shiguangjianke.smartfoodsystem.entity.User;
import com.shiguangjianke.smartfoodsystem.service.UserService;
import com.shiguangjianke.smartfoodsystem.service.impl.UserServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController
extends BaseController {
    @Autowired
    private UserService userService;

    @PostMapping(value={"/wechat/login"})
    public Result wechatLogin(@RequestParam String openid) {
        User user = this.userService.getByOpenid(openid);
        if (user == null) {
            user = new User();
            user.setOpenid(openid);
            user.setUserType(Integer.valueOf(1));
            this.userService.save((Object)user);
        }
        return this.success((Object)user);
    }

    @PostMapping(value={"/user/login"})
    public Result userLogin(@RequestBody LoginDto loginDto) {
        User user = ((UserServiceImpl)this.userService).userLogin(loginDto.getUsername(), loginDto.getPassword());
        if (user == null) {
            return this.error(401, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return this.success((Object)user);
    }

    @PostMapping(value={"/merchant/login"})
    public Result merchantLogin(@RequestBody LoginDto loginDto) {
        User user = this.userService.merchantLogin(loginDto.getUsername(), loginDto.getPassword());
        if (user == null) {
            return this.error(401, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return this.success((Object)user);
    }

    @PostMapping(value={"/admin/login"})
    public Result adminLogin(@RequestBody LoginDto loginDto) {
        User user = this.userService.adminLogin(loginDto.getUsername(), loginDto.getPassword());
        if (user == null) {
            return this.error(401, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return this.success((Object)user);
    }

    @PostMapping(value={"/user/register"})
    public Result userRegister(@RequestBody User user) {
        user.setUserType(Integer.valueOf(1));
        String encryptedPassword = DigestUtils.md5DigestAsHex((byte[])user.getPassword().getBytes());
        user.setPassword(encryptedPassword);
        this.userService.save((Object)user);
        return this.success((Object)"\u6ce8\u518c\u6210\u529f");
    }

    @PostMapping(value={"/merchant/register"})
    public Result merchantRegister(@RequestBody User user) {
        user.setUserType(Integer.valueOf(2));
        user.setMerchantApplyStatus(Integer.valueOf(0));
        String encryptedPassword = DigestUtils.md5DigestAsHex((byte[])user.getPassword().getBytes());
        user.setPassword(encryptedPassword);
        this.userService.save((Object)user);
        return this.success((Object)"\u6ce8\u518c\u6210\u529f\uff0c\u7b49\u5f85\u5ba1\u6838");
    }

    @PutMapping(value={"/merchant/update"})
    public Result updateMerchant(@RequestBody User user) {
        this.userService.updateById((Object)user);
        return this.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public Result updateUser(@RequestBody User user) {
        this.userService.updateById((Object)user);
        return this.success((Object)user);
    }
}

